/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.singlestore;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.singlestore.SingleStoreDatabase;
import org.flywaydb.database.singlestore.SingleStoreSchema;

public class SingleStoreConnection
extends org.flywaydb.core.internal.database.base.Connection<SingleStoreDatabase> {
    @Generated
    private static final Log LOG = LogFactory.getLog(SingleStoreConnection.class);
    private static final String USER_VARIABLES_TABLE = "information_schema.user_variables";
    private static final String USER_VARIABLES_QUERY = "SELECT variable_name FROM information_schema.user_variables WHERE variable_value IS NOT NULL";
    private final boolean canResetUserVariables = this.hasUserVariableResetCapability();

    public SingleStoreConnection(SingleStoreDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    private boolean hasUserVariableResetCapability() {
        try {
            this.jdbcTemplate.queryForStringList(USER_VARIABLES_QUERY, new String[0]);
        }
        catch (SQLException e) {
            LOG.debug("Disabled user variable reset as information_schema.user_variables cannot be queried (SQL State: " + e.getSQLState() + ", Error Code: " + e.getErrorCode() + ")");
            return false;
        }
        return true;
    }

    protected void doRestoreOriginalState() throws SQLException {
        List userVariables;
        if (this.canResetUserVariables && !(userVariables = this.jdbcTemplate.queryForStringList(USER_VARIABLES_QUERY, new String[0])).isEmpty()) {
            String nulls = String.join((CharSequence)",", Collections.nCopies(userVariables.size(), "NULL"));
            String variables = String.join((CharSequence)",", userVariables);
            this.jdbcTemplate.executeStatement("SELECT " + nulls + " INTO " + variables);
        }
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT DATABASE()", new String[0]);
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        if (StringUtils.hasLength((String)schema)) {
            this.jdbcTemplate.getConnection().setCatalog(schema);
        } else {
            try {
                String newDb = ((SingleStoreDatabase)this.database).quote(new String[]{UUID.randomUUID().toString()});
                this.jdbcTemplate.execute("CREATE SCHEMA " + newDb, new Object[0]);
                this.jdbcTemplate.execute("USE " + newDb, new Object[0]);
                this.jdbcTemplate.execute("DROP SCHEMA " + newDb, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Unable to restore connection to having no default schema: " + e.getMessage());
            }
        }
    }

    protected Schema doGetCurrentSchema() throws SQLException {
        String schemaName = this.getCurrentSchemaNameOrSearchPath();
        return schemaName == null ? null : this.getSchema(schemaName);
    }

    public Schema getSchema(String name) {
        return new SingleStoreSchema(this.jdbcTemplate, (SingleStoreDatabase)this.database, name);
    }
}

