/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.readers;

import java.nio.charset.Charset;
import java.util.stream.Stream;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.nc.ConnectionType;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.Reader;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.nc.FileReadingWithPlaceholderReplacement;
import org.flywaydb.nc.executors.NonJdbcExecutorExecutionUnit;

public class NonJdbcReader
implements Reader<NonJdbcExecutorExecutionUnit> {
    public Stream<NonJdbcExecutorExecutionUnit> read(Configuration configuration, NativeConnectorsDatabase database, ParsingContext parsingContext, LoadableResource loadableResource, SqlScriptMetadata metadata) {
        Charset encoding = metadata != null && metadata.encoding() != null ? Charset.forName(metadata.encoding()) : configuration.getEncoding();
        String content = FileReadingWithPlaceholderReplacement.readFile(configuration, parsingContext, loadableResource.getAbsolutePath(), encoding);
        return Stream.of(new NonJdbcExecutorExecutionUnit(content, FileUtils.getParentDir((String)loadableResource.getAbsolutePath()), encoding));
    }

    public boolean canRead(ConnectionType connectionType) {
        return connectionType == ConnectionType.EXECUTABLE || connectionType == ConnectionType.API;
    }
}

