/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.migration;

import java.util.Arrays;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.internal.nc.MigrationTypeResolver;

public class CoreMigrationTypeResolver
implements MigrationTypeResolver {
    public MigrationType resolveMigrationType(String filename, Configuration configuration) {
        String[] split = filename.split("\\.");
        String suffix = "." + split[split.length - 1];
        String[] sqlMigrationSuffixes = configuration.getSqlMigrationSuffixes();
        String sqlMigrationPrefix = configuration.getSqlMigrationPrefix();
        String repeatableMigrationPrefix = configuration.getRepeatableSqlMigrationPrefix();
        if (filename.startsWith(sqlMigrationPrefix) || filename.startsWith(repeatableMigrationPrefix)) {
            if (Arrays.asList(sqlMigrationSuffixes).contains(suffix)) {
                return CoreMigrationType.SQL;
            }
            return CoreMigrationType.JDBC;
        }
        return null;
    }

    public MigrationType resolveMigrationTypeFromName(String name, Configuration configuration) {
        return CoreMigrationType.fromString((String)name);
    }
}

