/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.migration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.internal.nc.NativeConnectorsMigrationScanner;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resolver.ChecksumCalculator;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.util.Pair;

public class MigrationScannerManager {
    @Generated
    private static final Log LOG = LogFactory.getLog(MigrationScannerManager.class);
    private final List<? extends NativeConnectorsMigrationScanner> scanners;

    public MigrationScannerManager(Configuration configuration) {
        this(configuration.getPluginRegister().getInstancesOf(NativeConnectorsMigrationScanner.class));
    }

    public MigrationScannerManager(List<? extends NativeConnectorsMigrationScanner> scanners) {
        this.scanners = scanners;
    }

    public Collection<LoadableResourceMetadata> scan(Configuration configuration, ParsingContext parsingContext) {
        if (this.scanners.isEmpty()) {
            LOG.warn("Native Connectors Mode is set but no migrations scanners loaded");
            return Collections.emptyList();
        }
        List<LoadableResourceMetadata> resources = Arrays.stream(configuration.getLocations()).flatMap(location -> this.scan((Location)location, configuration, parsingContext).stream()).map(resource -> MigrationScannerManager.getLoadableResourceMetadata((Pair<LoadableResource, SqlScriptMetadata>)resource, configuration, parsingContext)).toList();
        HashSet resourceSet = new HashSet();
        resources.forEach(resource -> {
            if (resourceSet.contains(resource)) {
                LoadableResourceMetadata first = resourceSet.stream().filter(loadableResourceMetadata -> loadableResourceMetadata.equals(resource)).findFirst().get();
                if (first.version() != null) {
                    throw new FlywayException(String.format("Found more than one migration with version %s\nOffenders:\n-> %s \n-> %s", resource.version(), resource.loadableResource().getAbsolutePath(), first.loadableResource().getAbsolutePath()), (ErrorCode)CoreErrorCode.DUPLICATE_VERSIONED_MIGRATION);
                }
                throw new FlywayException(String.format("Found more than one repeatable migration with description '%s'\nOffenders:\n-> %s \n-> %s ", resource.description(), resource.loadableResource().getAbsolutePath(), first.loadableResource().getAbsolutePath()), (ErrorCode)CoreErrorCode.DUPLICATE_REPEATABLE_MIGRATION);
            }
            resourceSet.add(resource);
        });
        return resources;
    }

    private static LoadableResourceMetadata getLoadableResourceMetadata(Pair<LoadableResource, SqlScriptMetadata> resource, Configuration configuration, ParsingContext parsingContext) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        ResourceName resourceName = resourceNameParser.parse(((LoadableResource)resource.getLeft()).getFilename());
        SqlScriptMetadata sqlScriptMetadata = (SqlScriptMetadata)resource.getRight();
        boolean placeholderReplacement = sqlScriptMetadata == null || sqlScriptMetadata.placeholderReplacement() == null ? configuration.isPlaceholderReplacement() : sqlScriptMetadata.placeholderReplacement().booleanValue();
        int checksum = MigrationScannerManager.getChecksumForLoadableResource(Objects.equals(resourceName.getPrefix(), configuration.getRepeatableSqlMigrationPrefix()), placeholderReplacement, (LoadableResource)resource.getLeft(), resourceName, configuration, parsingContext);
        return new LoadableResourceMetadata(resourceName.getVersion(), resourceName.getDescription(), resourceName.getPrefix(), placeholderReplacement ? LoadableResource.createPlaceholderReplacingLoadableResource((LoadableResource)((LoadableResource)resource.getLeft()), (Configuration)configuration, (ParsingContext)parsingContext) : (LoadableResource)resource.getLeft(), (SqlScriptMetadata)resource.getRight(), checksum, null);
    }

    private static Integer getChecksumForLoadableResource(boolean repeatable, boolean placeholderReplacement, LoadableResource resource, ResourceName resourceName, Configuration configuration, ParsingContext parsingContext) {
        if (repeatable && placeholderReplacement) {
            parsingContext.updateFilenamePlaceholder(resourceName, configuration);
            return ChecksumCalculator.calculate((LoadableResource[])new LoadableResource[]{LoadableResource.createPlaceholderReplacingLoadableResource((LoadableResource)resource, (Configuration)configuration, (ParsingContext)parsingContext)});
        }
        return ChecksumCalculator.calculate((LoadableResource[])new LoadableResource[]{resource});
    }

    private Collection<Pair<LoadableResource, SqlScriptMetadata>> scan(Location location, Configuration configuration, ParsingContext parsingContext) {
        return this.scanners.stream().flatMap(scanner -> scanner.scan(location, configuration, parsingContext).stream()).toList();
    }
}

