/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.callbacks;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.internal.nc.CallbackHandler;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.parser.ParsingContext;

public class CallbackManager {
    @Generated
    private static final Log LOG = LogFactory.getLog(CallbackManager.class);
    private final List<? extends CallbackHandler> callbackHandlers;

    public CallbackManager(Configuration configuration, Collection<LoadableResourceMetadata> resources) {
        this.callbackHandlers = configuration.getPluginRegister().getPlugins(CallbackHandler.class);
        if (this.callbackHandlers.isEmpty()) {
            LOG.warn("Native Connectors Mode is set but no callback handlers loaded");
            return;
        }
        if (!configuration.isSkipDefaultCallbacks()) {
            this.callbackHandlers.forEach(x -> x.registerCallbacks(resources));
        }
    }

    public void handleEvent(Event event, NativeConnectorsDatabase database, Configuration configuration, ParsingContext parsingContext) {
        this.callbackHandlers.forEach(x -> x.handleEvent(event, database, configuration, parsingContext));
    }
}

