/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.utils;

import java.nio.file.Path;
import lombok.Generated;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.nc.Executor;
import org.flywaydb.core.internal.util.StringUtils;

public class ErrorUtils {
    @Generated
    private static final Log LOG = LogFactory.getLog(ErrorUtils.class);

    public static <T> String calculateErrorMessage(String title, LoadableResource loadableResource, String physicalLocation, Executor<T> executor, T executionUnit, String message) {
        String underline = StringUtils.trimOrPad((String)"", (int)title.length(), (char)'-');
        StringBuilder messageBuilder = new StringBuilder().append(title).append("\n").append(underline).append("\n");
        if (message != null) {
            messageBuilder.append(message);
        }
        if (loadableResource != null) {
            messageBuilder.append("Location   : ").append(loadableResource.getAbsolutePath()).append(" (").append(loadableResource.getAbsolutePathOnDisk()).append(")\n");
        } else {
            messageBuilder.append("Location   : ").append(physicalLocation);
        }
        if (executionUnit != null && executor != null) {
            executor.appendErrorMessage(executionUnit, messageBuilder, LOG.isDebugEnabled());
        }
        return messageBuilder.toString();
    }

    public static String getScriptExecutionErrorMessageTitle(Path scriptName, String environment) {
        StringBuilder messageBuilder = new StringBuilder("Failed to execute script ").append(scriptName);
        if (!"default".equalsIgnoreCase(environment)) {
            messageBuilder.append(" against ").append(environment).append(" environment");
        }
        return messageBuilder.toString();
    }
}

