/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.migration;

import java.util.Arrays;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.migration.baseline.BaselineMigrationConfigurationExtension;
import org.flywaydb.core.api.migration.baseline.BaselineMigrationType;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.internal.nc.MigrationTypeResolver;

public class BaselineMigrationTypeResolver
implements MigrationTypeResolver {
    public MigrationType resolveMigrationType(String filename, Configuration configuration) {
        BaselineMigrationConfigurationExtension baselineConfiguration = (BaselineMigrationConfigurationExtension)configuration.getPluginRegister().getPlugin(BaselineMigrationConfigurationExtension.class);
        if (filename.startsWith(baselineConfiguration.getBaselineMigrationPrefix())) {
            String[] split = filename.split("\\.");
            String suffix = "." + split[split.length - 1];
            if (Arrays.asList(configuration.getSqlMigrationSuffixes()).contains(suffix)) {
                return BaselineMigrationType.SQL_BASELINE;
            }
            return BaselineMigrationType.JDBC_BASELINE;
        }
        return null;
    }

    public MigrationType resolveMigrationTypeFromName(String name, Configuration configuration) {
        return BaselineMigrationType.fromString((String)name);
    }
}

