/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc;

import java.util.Optional;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigurationValidator;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.NativeConnectorsModeUtils;
import org.flywaydb.core.internal.nc.NativeConnectorsSupport;
import org.flywaydb.nc.utils.NativeConnectorsUtils;

public class NativeConnectorsSupportImpl
implements NativeConnectorsSupport {
    private static final Log LOG = LogFactory.getLog(NativeConnectorsSupportImpl.class);

    public boolean canUseNativeConnectors(Configuration configuration, String verb) {
        if (NativeConnectorsModeUtils.isNativeConnectorsTurnedOff()) {
            return false;
        }
        if (NativeConnectorsSupportImpl.useLegacyAsDryRunSet(configuration)) {
            if (NativeConnectorsModeUtils.isNativeConnectorsTurnedOn()) {
                LOG.warn("Dry run is not supported in Native Connectors mode, falling back to legacy databases");
            }
            return false;
        }
        if (configuration.getUrl() == null) {
            return false;
        }
        new ConfigurationValidator().validate(configuration);
        Optional<NativeConnectorsDatabase> database = NativeConnectorsUtils.resolveExperimentalDatabasePlugin(configuration);
        return database.map(experimentalDatabase -> experimentalDatabase.supportedVerbs().contains(verb) && (experimentalDatabase.isOnByDefault(configuration) || NativeConnectorsModeUtils.isNativeConnectorsTurnedOn())).orElse(false);
    }

    public boolean canCreateDataSource(Configuration configuration) {
        if (NativeConnectorsSupportImpl.useLegacyAsDryRunSet(configuration)) {
            return true;
        }
        if (!NativeConnectorsModeUtils.isNativeConnectorsTurnedOff()) {
            if (configuration.getUrl() == null) {
                return true;
            }
            Optional<NativeConnectorsDatabase> database = NativeConnectorsUtils.resolveExperimentalDatabasePlugin(configuration);
            return database.map(experimentalDatabase -> experimentalDatabase.canCreateJdbcDataSource() || !experimentalDatabase.isOnByDefault(configuration)).orElse(true);
        }
        return true;
    }

    private static boolean useLegacyAsDryRunSet(Configuration config) {
        return config.getDryRunOutput() != null;
    }
}

