/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.callbacks;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.experimental.CallbackHandler;
import org.flywaydb.core.experimental.Executor;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.Reader;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.nc.callbacks.Callback;
import org.flywaydb.nc.executors.ExecutorFactory;
import org.flywaydb.nc.executors.JdbcExecutor;
import org.flywaydb.nc.executors.NonJdbcExecutorExecutionUnit;
import org.flywaydb.nc.readers.ReaderFactory;
import org.flywaydb.nc.utils.ErrorUtils;
import org.flywaydb.nc.utils.VerbUtils;

public class NativeConnectorsCallbackHandler
implements CallbackHandler {
    private static final Log LOG = LogFactory.getLog(NativeConnectorsCallbackHandler.class);
    private final Collection<Callback> callbacks = new ArrayList<Callback>();

    public void handleEvent(Event event, ExperimentalDatabase database, Configuration configuration, ParsingContext parsingContext) {
        this.callbacks.stream().filter(x -> x.supports(event)).forEach(x -> this.handleEvent((Callback)x, database, configuration, parsingContext));
    }

    private void handleEvent(Callback callback, ExperimentalDatabase database, Configuration configuration, ParsingContext parsingContext) {
        Reader reader = ReaderFactory.getReader((ExperimentalDatabase)database, (Configuration)configuration);
        Stream executionUnits = reader.read(configuration, database, parsingContext, callback.getLoadableResourceMetadata().loadableResource(), callback.getLoadableResourceMetadata().sqlScriptMetadata());
        Executor executor = ExecutorFactory.getExecutor((ExperimentalDatabase)database, (Configuration)configuration);
        LOG.info("Callback executed: " + callback.getEvent().name() + " from " + callback.getPhysicalLocation());
        try (EventTelemetryModel telemetryModel = new EventTelemetryModel(callback.getEvent().getId(), VerbUtils.getFlywayTelemetryManager((Configuration)configuration));){
            executionUnits.forEach(executionUnit -> {
                Object executionUnitObj;
                if (executor instanceof JdbcExecutor) {
                    executionUnitObj = executionUnit;
                } else {
                    String parentDir = FileUtils.getParentDir((String)callback.getLoadableResourceMetadata().loadableResource().getAbsolutePath());
                    executionUnitObj = new NonJdbcExecutorExecutionUnit((String)executionUnit, parentDir);
                }
                try {
                    executor.execute(database, executionUnitObj, configuration);
                }
                catch (Exception e) {
                    String title = "Error while executing " + callback.getEvent().getId() + " callback: " + ErrorUtils.getScriptExecutionErrorMessageTitle((Path)Paths.get(callback.getFileName(), new String[0]).getFileName(), (String)configuration.getCurrentEnvironmentName());
                    String errorMessage = ErrorUtils.calculateErrorMessage((String)title, (LoadableResource)callback.getLoadableResourceMetadata().loadableResource(), (String)callback.getPhysicalLocation(), (Executor)executor, (Object)executionUnitObj, (String)("Message    : " + e.getMessage() + "\n"));
                    throw new FlywayException(errorMessage);
                }
            });
            executor.finishExecution(database, configuration);
        }
    }

    public void registerCallbacks(Collection<LoadableResourceMetadata> resources) {
        this.callbacks.clear();
        resources.stream().map(resource -> {
            Event event = Event.fromId((String)resource.prefix());
            if (event != null) {
                LOG.debug("Callback registered: " + event.name() + " from " + resource.loadableResource().getAbsolutePath());
                return new Callback((LoadableResourceMetadata)resource, event);
            }
            return null;
        }).filter(Objects::nonNull).forEach(this.callbacks::add);
    }
}

