/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.maven.MavenLogCreator;

abstract class AbstractFlywayMojo
extends AbstractMojo {
    private static final String CONFIG_WORKING_DIRECTORY = "flyway.workingDirectory";
    private static final String CONFIG_SERVER_ID = "flyway.serverId";
    private static final String CONFIG_VERSION = "flyway.version";
    private static final String CONFIG_SKIP = "flyway.skip";
    private static final String CONFIG_CURRENT = "flyway.current";
    Log log;
    @Parameter(property="flyway.skip")
    boolean skip;
    @Parameter(property="flyway.driver")
    String driver;
    @Parameter(property="flyway.url")
    String url;
    @Parameter(property="flyway.user")
    String user;
    @Parameter(property="flyway.password")
    private String password;
    @Parameter
    private String[] schemas;
    @Parameter(property="flyway.table")
    private String table;
    @Parameter(property="flyway.baselineVersion")
    private String baselineVersion;
    @Parameter(property="flyway.baselineDescription")
    private String baselineDescription;
    @Parameter
    private String[] locations;
    @Parameter
    private String[] resolvers;
    @Parameter(property="flyway.skipDefaultResolvers")
    private Boolean skipDefaultResolvers;
    @Parameter(property="flyway.encoding")
    private String encoding;
    @Parameter(property="flyway.sqlMigrationPrefix")
    private String sqlMigrationPrefix;
    @Parameter(property="flyway.undoSqlMigrationPrefix")
    private String undoSqlMigrationPrefix;
    @Parameter(property="flyway.repeatableSqlMigrationPrefix")
    private String repeatableSqlMigrationPrefix;
    @Parameter(property="flyway.sqlMigrationSeparator")
    private String sqlMigrationSeparator;
    @Deprecated
    @Parameter(property="flyway.sqlMigrationSuffix")
    private String sqlMigrationSuffix;
    @Parameter
    private String[] sqlMigrationSuffixes;
    @Parameter(property="flyway.cleanOnValidationError")
    private Boolean cleanOnValidationError;
    @Parameter(property="flyway.cleanDisabled")
    private Boolean cleanDisabled;
    @Parameter(property="flyway.target")
    private String target;
    @Parameter(property="flyway.outOfOrder")
    private Boolean outOfOrder;
    @Parameter(property="flyway.ignoreMissingMigrations")
    private Boolean ignoreMissingMigrations;
    @Parameter(property="flyway.ignoreIgnoredMigrations")
    private Boolean ignoreIgnoredMigrations;
    @Parameter(property="flyway.ignoreFutureMigrations")
    private Boolean ignoreFutureMigrations;
    @Parameter(property="flyway.placeholderReplacement")
    private Boolean placeholderReplacement;
    @Parameter
    private Map<String, String> placeholders;
    @Parameter(property="flyway.placeholderPrefix")
    private String placeholderPrefix;
    @Parameter(property="flyway.placeholderSuffix")
    private String placeholderSuffix;
    @Parameter
    private String[] callbacks;
    @Parameter(property="flyway.skipDefaultCallbacks")
    private Boolean skipDefaultCallbacks;
    @Parameter(property="flyway.baselineOnMigrate")
    private Boolean baselineOnMigrate;
    @Parameter(property="flyway.validateOnMigrate")
    private Boolean validateOnMigrate;
    @Parameter(property="flyway.mixed")
    private Boolean mixed;
    @Parameter(property="flyway.group")
    private Boolean group;
    @Parameter(property="flyway.installedBy")
    private String installedBy;
    @Parameter
    private String[] errorHandlers;
    @Parameter
    private String[] errorOverrides;
    @Parameter(property="flyway.dryRunOutput")
    private String dryRunOutput;
    @Parameter(property="flyway.stream")
    private Boolean stream;
    @Parameter(property="flyway.batch")
    private Boolean batch;
    @Parameter(property="flyway.oracle.sqlplus")
    private Boolean oracleSqlplus;
    @Deprecated
    @Parameter(property="flyway.configFile")
    private File configFile;
    @Parameter(property="flyway.configFileEncoding")
    private String configFileEncoding;
    private File[] configFiles;
    @Parameter(property="flyway.workingDirectory")
    private File workingDirectory;
    @Parameter(property="flyway.serverId")
    private String serverId = "flyway-db";
    @Parameter(defaultValue="${settings}", readonly=true)
    Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject mavenProject;
    @Component
    private SettingsDecrypter settingsDecrypter;

    AbstractFlywayMojo() {
    }

    private void loadCredentialsFromSettings() throws FlywayException {
        Server server = this.settings.getServer(this.serverId);
        if (this.user == null) {
            if (server != null) {
                this.user = server.getUsername();
                SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
                for (SettingsProblem problem : result.getProblems()) {
                    if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
                    throw new FlywayException("Unable to decrypt password: " + problem, (Throwable)problem.getException());
                }
                this.password = result.getServer().getPassword();
            }
        } else if (server != null) {
            throw new FlywayException("You specified credentials both in the Flyway config and settings.xml. Use either one or the other");
        }
    }

    boolean getBooleanProperty(String systemPropertyName, boolean mavenPropertyValue) {
        String systemPropertyValue = System.getProperty(systemPropertyName);
        if (systemPropertyValue != null) {
            return Boolean.getBoolean(systemPropertyName);
        }
        return mavenPropertyValue;
    }

    public final void execute() throws MojoExecutionException {
        LogFactory.setLogCreator((LogCreator)new MavenLogCreator(this));
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        if (this.getBooleanProperty(CONFIG_SKIP, this.skip)) {
            this.log.info("Skipping Flyway execution");
            return;
        }
        try {
            File workDir;
            HashSet classpathElements = new HashSet();
            classpathElements.addAll(this.mavenProject.getCompileClasspathElements());
            classpathElements.addAll(this.mavenProject.getRuntimeClasspathElements());
            ClassRealm classLoader = (ClassRealm)Thread.currentThread().getContextClassLoader();
            for (String classpathElement : classpathElements) {
                classLoader.addURL(new File(classpathElement).toURI().toURL());
            }
            File file = workDir = this.workingDirectory == null ? this.mavenProject.getBasedir() : this.workingDirectory;
            if (this.locations != null) {
                for (int i = 0; i < this.locations.length; ++i) {
                    if (!this.locations[i].startsWith("filesystem:")) continue;
                    String newLocation = this.locations[i].substring("filesystem:".length());
                    Object file2 = new File(newLocation);
                    if (!((File)file2).isAbsolute()) {
                        file2 = new File(workDir, newLocation);
                    }
                    this.locations[i] = "filesystem:" + ((File)file2).getAbsolutePath();
                }
            } else {
                this.locations = new String[]{"filesystem:" + workDir.getAbsolutePath() + "/src/main/resources/db/migration"};
            }
            Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
            HashMap<String, String> conf = new HashMap<String, String>(this.loadConfigurationFromDefaultConfigFiles(envVars));
            this.loadCredentialsFromSettings();
            ConfigUtils.putIfSet(conf, (String)"flyway.driver", (Object[])new Object[]{this.driver});
            ConfigUtils.putIfSet(conf, (String)"flyway.url", (Object[])new Object[]{this.url});
            ConfigUtils.putIfSet(conf, (String)"flyway.user", (Object[])new Object[]{this.user});
            ConfigUtils.putIfSet(conf, (String)"flyway.password", (Object[])new Object[]{this.password});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.schemas", (String[][])new String[][]{this.schemas});
            ConfigUtils.putIfSet(conf, (String)"flyway.table", (Object[])new Object[]{this.table});
            ConfigUtils.putIfSet(conf, (String)"flyway.baselineVersion", (Object[])new Object[]{this.baselineVersion});
            ConfigUtils.putIfSet(conf, (String)"flyway.baselineDescription", (Object[])new Object[]{this.baselineDescription});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.locations", (String[][])new String[][]{this.locations});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.resolvers", (String[][])new String[][]{this.resolvers});
            ConfigUtils.putIfSet(conf, (String)"flyway.skipDefaultResolvers", (Object[])new Object[]{this.skipDefaultResolvers});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.callbacks", (String[][])new String[][]{this.callbacks});
            ConfigUtils.putIfSet(conf, (String)"flyway.skipDefaultCallbacks", (Object[])new Object[]{this.skipDefaultCallbacks});
            ConfigUtils.putIfSet(conf, (String)"flyway.encoding", (Object[])new Object[]{this.encoding});
            ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationPrefix", (Object[])new Object[]{this.sqlMigrationPrefix});
            ConfigUtils.putIfSet(conf, (String)"flyway.undoSqlMigrationPrefix", (Object[])new Object[]{this.undoSqlMigrationPrefix});
            ConfigUtils.putIfSet(conf, (String)"flyway.repeatableSqlMigrationPrefix", (Object[])new Object[]{this.repeatableSqlMigrationPrefix});
            ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationSeparator", (Object[])new Object[]{this.sqlMigrationSeparator});
            ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationSuffix", (Object[])new Object[]{this.sqlMigrationSuffix});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.sqlMigrationSuffixes", (String[][])new String[][]{this.sqlMigrationSuffixes});
            ConfigUtils.putIfSet(conf, (String)"flyway.mixed", (Object[])new Object[]{this.mixed});
            ConfigUtils.putIfSet(conf, (String)"flyway.group", (Object[])new Object[]{this.group});
            ConfigUtils.putIfSet(conf, (String)"flyway.installedBy", (Object[])new Object[]{this.installedBy});
            ConfigUtils.putIfSet(conf, (String)"flyway.cleanOnValidationError", (Object[])new Object[]{this.cleanOnValidationError});
            ConfigUtils.putIfSet(conf, (String)"flyway.cleanDisabled", (Object[])new Object[]{this.cleanDisabled});
            ConfigUtils.putIfSet(conf, (String)"flyway.outOfOrder", (Object[])new Object[]{this.outOfOrder});
            ConfigUtils.putIfSet(conf, (String)"flyway.target", (Object[])new Object[]{this.target});
            ConfigUtils.putIfSet(conf, (String)"flyway.ignoreMissingMigrations", (Object[])new Object[]{this.ignoreMissingMigrations});
            ConfigUtils.putIfSet(conf, (String)"flyway.ignoreIgnoredMigrations", (Object[])new Object[]{this.ignoreIgnoredMigrations});
            ConfigUtils.putIfSet(conf, (String)"flyway.ignoreFutureMigrations", (Object[])new Object[]{this.ignoreFutureMigrations});
            ConfigUtils.putIfSet(conf, (String)"flyway.placeholderReplacement", (Object[])new Object[]{this.placeholderReplacement});
            ConfigUtils.putIfSet(conf, (String)"flyway.placeholderPrefix", (Object[])new Object[]{this.placeholderPrefix});
            ConfigUtils.putIfSet(conf, (String)"flyway.placeholderSuffix", (Object[])new Object[]{this.placeholderSuffix});
            ConfigUtils.putIfSet(conf, (String)"flyway.baselineOnMigrate", (Object[])new Object[]{this.baselineOnMigrate});
            ConfigUtils.putIfSet(conf, (String)"flyway.validateOnMigrate", (Object[])new Object[]{this.validateOnMigrate});
            ConfigUtils.putIfSet(conf, (String)"flyway.driver", (Object[])new Object[]{this.driver});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.errorHandlers", (String[][])new String[][]{this.errorHandlers});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.errorOverrides", (String[][])new String[][]{this.errorOverrides});
            ConfigUtils.putIfSet(conf, (String)"flyway.dryRunOutput", (Object[])new Object[]{this.dryRunOutput});
            ConfigUtils.putIfSet(conf, (String)"flyway.stream", (Object[])new Object[]{this.stream});
            ConfigUtils.putIfSet(conf, (String)"flyway.batch", (Object[])new Object[]{this.batch});
            ConfigUtils.putIfSet(conf, (String)"flyway.oracle.sqlplus", (Object[])new Object[]{this.oracleSqlplus});
            if (this.placeholders != null) {
                for (String placeholder : this.placeholders.keySet()) {
                    String value = this.placeholders.get(placeholder);
                    conf.put("flyway.placeholders." + placeholder, value == null ? "" : value);
                }
            }
            conf.putAll(ConfigUtils.propertiesToMap((Properties)this.mavenProject.getProperties()));
            conf.putAll(this.loadConfigurationFromConfigFiles(workDir, envVars));
            conf.putAll(envVars);
            conf.putAll(ConfigUtils.propertiesToMap((Properties)System.getProperties()));
            AbstractFlywayMojo.removeMavenPluginSpecificPropertiesToAvoidWarnings(conf);
            Flyway flyway = new Flyway((ClassLoader)classLoader);
            flyway.configure(conf);
            this.doExecute(flyway);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), ExceptionUtils.getRootCause((Throwable)e));
        }
    }

    private List<File> determineConfigFiles(File workDir, Map<String, String> envVars) {
        ArrayList<File> configFiles = new ArrayList<File>();
        if (envVars.containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)envVars.get("flyway.configFiles"), (String)",")) {
                configFiles.add(this.toFile(workDir, file));
            }
            return configFiles;
        }
        if (System.getProperties().containsKey("flyway.configFile")) {
            this.log.warn("flyway.configFile is deprecated and will be removed in Flyway 6.0. Use flyway.configFiles instead.");
            configFiles.add(this.toFile(workDir, System.getProperties().getProperty("flyway.configFile")));
            return configFiles;
        }
        if (System.getProperties().containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)System.getProperties().getProperty("flyway.configFiles"), (String)",")) {
                configFiles.add(this.toFile(workDir, file));
            }
            return configFiles;
        }
        if (this.mavenProject.getProperties().containsKey("flyway.configFile")) {
            this.log.warn("flyway.configFile is deprecated and will be removed in Flyway 6.0. Use flyway.configFiles instead.");
            configFiles.add(this.toFile(workDir, this.mavenProject.getProperties().getProperty("flyway.configFile")));
        } else if (this.configFile != null) {
            configFiles.add(this.configFile);
        }
        if (this.mavenProject.getProperties().containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)this.mavenProject.getProperties().getProperty("flyway.configFiles"), (String)",")) {
                configFiles.add(this.toFile(workDir, file));
            }
        } else if (this.configFiles != null) {
            configFiles.addAll(Arrays.asList(this.configFiles));
        }
        return configFiles;
    }

    private File toFile(File workDir, String fileName) {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(workDir, fileName);
    }

    private String determineConfigurationFileEncoding(Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        if (System.getProperties().containsKey("flyway.configFileEncoding")) {
            return System.getProperties().getProperty("flyway.configFileEncoding");
        }
        if (this.configFileEncoding != null) {
            return this.configFileEncoding;
        }
        return "UTF-8";
    }

    private static void removeMavenPluginSpecificPropertiesToAvoidWarnings(Map<String, String> conf) {
        conf.remove("flyway.configFile");
        conf.remove("flyway.configFiles");
        conf.remove("flyway.configFileEncoding");
        conf.remove(CONFIG_CURRENT);
        conf.remove(CONFIG_SKIP);
        conf.remove(CONFIG_VERSION);
        conf.remove(CONFIG_SERVER_ID);
        conf.remove(CONFIG_WORKING_DIRECTORY);
    }

    private Map<String, String> loadConfigurationFromConfigFiles(File workDir, Map<String, String> envVars) {
        String encoding = this.determineConfigurationFileEncoding(envVars);
        HashMap<String, String> conf = new HashMap<String, String>();
        for (File configFile : this.determineConfigFiles(workDir, envVars)) {
            conf.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
        return conf;
    }

    private Map<String, String> loadConfigurationFromDefaultConfigFiles(Map<String, String> envVars) {
        String encoding = this.determineConfigurationFileEncoding(envVars);
        File configFile = new File(System.getProperty("user.home") + "/" + "flyway.conf");
        return new HashMap<String, String>(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)false));
    }

    protected String getProperty(String name) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        return this.mavenProject.getProperties().getProperty(name);
    }

    protected abstract void doExecute(Flyway var1) throws Exception;
}

