/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.locations.s3;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.scanner.FileLocation;
import org.flywaydb.core.internal.scanner.ReadWriteLocationHandler;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.locations.s3.AwsS3Scanner;
import org.flywaydb.locations.s3.S3OutputStream;

public class AwsS3LocationHandler
implements ReadWriteLocationHandler {
    @Generated
    private static final Log LOG = LogFactory.getLog(AwsS3LocationHandler.class);
    private static final String AWS_S3_PREFIX = "s3:";

    public boolean canHandlePrefix(String prefix) {
        return AWS_S3_PREFIX.equals(prefix);
    }

    public Collection<LoadableResource> scanForResources(Location location, Configuration configuration) {
        FeatureDetector detector = new FeatureDetector(configuration.getClassLoader());
        if (detector.isAwsAvailable()) {
            return new AwsS3Scanner(configuration.getEncoding(), configuration.isFailOnMissingLocations()).scanForResources(location);
        }
        LOG.error("Can't read location " + String.valueOf(location) + "; AWS SDK not found");
        return Collections.emptyList();
    }

    public boolean handlesWildcards() {
        return false;
    }

    public String getPathSeparator() {
        return "/";
    }

    public String normalizePath(String path) {
        return path;
    }

    public OutputStream getOutputStream(FileLocation fileLocation, Configuration configuration) {
        return new S3OutputStream(fileLocation.path());
    }
}

