/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.spanner;

import java.sql.Connection;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.LinkUtils;
import org.flywaydb.database.spanner.SpannerDatabase;
import org.flywaydb.database.spanner.SpannerParser;

public class SpannerDatabaseType
extends BaseDatabaseType {
    public String getName() {
        return "Google Cloud Spanner";
    }

    public int getNullType() {
        return 0;
    }

    public int getPriority() {
        return -1;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:cloudspanner:") || url.startsWith("jdbc:p6spy:cloudspanner:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:cloudspanner:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "com.google.cloud.spanner.jdbc.JdbcDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.contains("Google Cloud Spanner");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SpannerDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new SpannerParser(configuration, parsingContext);
    }

    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("credentials=");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("credentials=");
    }

    public void printMessages() {
        LOG.info("Join the GCP Spanner beta via https://flywaydb.org/documentation/database/cloud-spanner#using-flyway-with-google-cloud-spanner");
        LOG.info("");
        LOG.info("Experiencing performance issues while using GCP Spanner?");
        LOG.info("Find out how Flyway Teams improves performance with batching at " + LinkUtils.createFlywayDbWebsiteLink((String[])new String[]{"documentation", "database", "cloud-spanner#flyway-teams-features-for-cloud-spanner"}));
    }
}

