/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.bigquery;

import java.sql.Connection;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.database.bigquery.BigQueryDatabase;
import org.flywaydb.database.bigquery.BigQueryParser;

public class BigQueryDatabaseType
extends BaseDatabaseType {
    @Generated
    private static final Log LOG = LogFactory.getLog(BigQueryDatabaseType.class);
    private static final String BIGQUERY_JDBC42_DRIVER = "com.simba.googlebigquery.jdbc42.Driver";
    private static final String BIGQUERY_JDBC_DRIVER = "com.simba.googlebigquery.jdbc.Driver";
    private static final Pattern OAUTH_CREDENTIALS_PATTERN = Pattern.compile("OAuth\\w+=([^;]*)", 2);

    public String getName() {
        return "Google Big Query";
    }

    public int getNullType() {
        return 0;
    }

    public Pattern getJDBCCredentialsPattern() {
        return OAUTH_CREDENTIALS_PATTERN;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:bigquery:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return BIGQUERY_JDBC42_DRIVER;
    }

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)BIGQUERY_JDBC_DRIVER, (ClassLoader)classLoader)) {
            return BIGQUERY_JDBC_DRIVER;
        }
        return null;
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.toLowerCase().contains("bigquery");
    }

    public void setOverridingConnectionProps(Map<String, String> props) {
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new BigQueryDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new BigQueryParser(configuration, parsingContext);
    }

    public String instantiateClassExtendedErrorMessage() {
        return "Failure probably due to inability to load dependencies. Please ensure you have downloaded 'https://cloud.google.com/bigquery/docs/reference/odbc-jdbc-drivers' and extracted to 'flyway/drivers' folder";
    }
}

