/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.bigquery;

import java.sql.SQLException;
import org.flywaydb.core.internal.database.InsertRowLock;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.bigquery.BigQueryDatabase;
import org.flywaydb.database.bigquery.BigQuerySchema;

public class BigQueryTable
extends Table<BigQueryDatabase, BigQuerySchema> {
    private final InsertRowLock insertRowLock;

    BigQueryTable(JdbcTemplate jdbcTemplate, BigQueryDatabase database, BigQuerySchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
        this.insertRowLock = new InsertRowLock(jdbcTemplate);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((BigQueryDatabase)this.database).quote(new String[]{((BigQuerySchema)this.schema).getName(), this.name}), new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        if (!((BigQuerySchema)this.schema).exists()) {
            return false;
        }
        return this.jdbcTemplate.queryForInt("SELECT COUNT(table_name) FROM " + ((BigQueryDatabase)this.database).quote(new String[]{((BigQuerySchema)this.schema).getName()}) + ".INFORMATION_SCHEMA.TABLES WHERE table_type='BASE TABLE' AND table_name=?", new String[]{this.name}) > 0;
    }

    protected void doLock() throws SQLException {
        String updateLockStatement = "UPDATE " + String.valueOf((Object)this) + " SET installed_on = CURRENT_TIMESTAMP() WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
        String deleteExpiredLockStatement = " DELETE FROM " + String.valueOf((Object)this) + " WHERE DESCRIPTION = 'flyway-lock' AND installed_on < TIMESTAMP '?'";
        if (this.lockDepth == 0) {
            this.insertRowLock.doLock(((BigQueryDatabase)this.database).getInsertStatement(this), updateLockStatement, deleteExpiredLockStatement, ((BigQueryDatabase)this.database).getBooleanTrue());
        }
    }

    protected void doUnlock() throws SQLException {
        if (this.lockDepth == 1) {
            this.insertRowLock.doUnlock(this.getDeleteLockTemplate());
        }
    }

    private String getDeleteLockTemplate() {
        return "DELETE FROM " + String.valueOf((Object)this) + " WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
    }
}

