/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.firebird;

import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.firebird.FirebirdDatabase;
import org.flywaydb.database.firebird.FirebirdSchema;

public class FirebirdTable
extends Table<FirebirdDatabase, FirebirdSchema> {
    public FirebirdTable(JdbcTemplate jdbcTemplate, FirebirdDatabase database, FirebirdSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + this, new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("select count(*) from RDB$RELATIONS\nwhere RDB$RELATION_NAME = ?\nand RDB$VIEW_BLR is null", new String[]{this.name}) > 0;
    }

    protected void doLock() throws SQLException {
        this.jdbcTemplate.execute("execute block as\ndeclare tempvar integer;\nbegin\n  for select 1 from " + this + " with lock into :tempvar do\n  begin\n  end\nend", new Object[0]);
    }

    public String toString() {
        return ((FirebirdDatabase)this.database).doQuote(this.name);
    }
}

