/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.postgresql.yugabytedb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.SqlCallable;

public class YugabyteDBExecutionTemplate {
    private static final Log LOG = LogFactory.getLog(YugabyteDBExecutionTemplate.class);
    private final JdbcTemplate jdbcTemplate;
    private final String tableName;
    private static final Map<String, Boolean> tableEntries = new ConcurrentHashMap<String, Boolean>();
    private static final Random random = new Random();
    public static final int DEFAULT_LOCK_ID_TTL = 300000;
    public static final int MAX_LOCK_ID_TTL = 3600000;
    public static final String LOCK_ID_TTL_SYS_PROP_NAME = "flyway.yugabytedb.lock-id-ttl-ms";

    YugabyteDBExecutionTemplate(JdbcTemplate jdbcTemplate, String tableName) {
        this.jdbcTemplate = jdbcTemplate;
        this.tableName = tableName;
    }

    public <T> T execute(Callable<T> callable) {
        Exception error = null;
        long lockId = 0L;
        try {
            lockId = this.lock();
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Exception e) {
            error = e;
            throw new FlywayException((Throwable)e);
        }
        finally {
            if (lockId != 0L) {
                this.unlock(lockId, error);
            }
        }
    }

    private long lock() throws SQLException {
        YBRetryStrategy strategy = new YBRetryStrategy();
        return strategy.doWithRetries((SqlCallable<Long>)((SqlCallable)this::tryLock), "Interrupted while attempting to acquire lock through SELECT ... FOR UPDATE", "Number of retries exceeded while attempting to acquire lock through SELECT ... FOR UPDATE. Configure the number of retries with the 'lockRetryCount' configuration option: https://rd.gt/3A57jfk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long tryLock() {
        long lockIdToBeReturned;
        block26: {
            FlywaySqlException exception = null;
            boolean txStarted = false;
            lockIdToBeReturned = 0L;
            Statement statement = null;
            try {
                statement = this.jdbcTemplate.getConnection().createStatement();
                if (!tableEntries.containsKey(this.tableName)) {
                    try {
                        String now = new Timestamp(Instant.now().getEpochSecond()).toString();
                        statement.executeUpdate("INSERT INTO YB_FLYWAY_LOCK_TABLE VALUES ('" + this.tableName + "', 0, '" + now + "')");
                        tableEntries.put(this.tableName, true);
                        LOG.info("insert query ts: " + now);
                        LOG.info(Thread.currentThread().getName() + "> Inserted a token row for " + this.tableName + " in YB_FLYWAY_LOCK_TABLE");
                    }
                    catch (SQLException e) {
                        if ("23505".equals(e.getSQLState())) {
                            LOG.debug(Thread.currentThread().getName() + "> Token row already added for " + this.tableName);
                        }
                        throw new FlywaySqlException("Could not add token row for " + this.tableName + " in table YB_FLYWAY_LOCK_TABLE", e);
                    }
                }
                long lockIdRead = 0L;
                String selectForUpdate = "SELECT lock_id, ts FROM YB_FLYWAY_LOCK_TABLE WHERE table_name = '" + this.tableName + "' FOR UPDATE";
                statement.execute("BEGIN");
                txStarted = true;
                ResultSet rs = statement.executeQuery(selectForUpdate);
                if (rs.next()) {
                    lockIdRead = rs.getLong("lock_id");
                    Timestamp tsRead = rs.getTimestamp("ts");
                    String current = new Timestamp(Instant.now().getEpochSecond()).toString();
                    long lockIdTtl = 300000L;
                    String sysProp = System.getProperty(LOCK_ID_TTL_SYS_PROP_NAME);
                    if (sysProp != null) {
                        try {
                            lockIdTtl = Long.parseLong(sysProp);
                            lockIdTtl = lockIdTtl < 0L || lockIdTtl > 3600000L ? 300000L : lockIdTtl;
                        }
                        catch (NumberFormatException e) {
                            LOG.warn("Invalid value for flyway.yugabytedb.lock-id-ttl-ms: " + sysProp + ". Using default value: 300000 ms");
                        }
                    }
                    if (lockIdRead == 0L || Instant.now().getEpochSecond() - tsRead.getTime() > lockIdTtl) {
                        lockIdToBeReturned = random.nextLong();
                        if (lockIdRead == 0L) {
                            LOG.debug(Thread.currentThread().getName() + "> Setting lock_id = " + lockIdToBeReturned);
                        } else {
                            LOG.warn(Thread.currentThread().getName() + "> Lock with lock_id " + lockIdRead + " is held for more than " + lockIdTtl + " millis. Resetting it with lock_id " + lockIdToBeReturned);
                        }
                        String updateLockId = "UPDATE YB_FLYWAY_LOCK_TABLE SET lock_id = " + lockIdToBeReturned + ", ts = '" + current + "' WHERE table_name = '" + this.tableName + "'";
                        LOG.debug(Thread.currentThread().getName() + "> executing query " + updateLockId);
                        statement.executeUpdate(updateLockId);
                    } else {
                        LOG.debug(Thread.currentThread().getName() + "> Another Flyway operation is in progress. Allowing it to complete");
                    }
                    break block26;
                }
                tableEntries.remove(this.tableName);
            }
            catch (SQLException e) {
                LOG.debug(Thread.currentThread().getName() + "> Unable to perform lock action, SQLState: " + e.getSQLState());
                if (!"40001".equalsIgnoreCase(e.getSQLState())) {
                    exception = new FlywaySqlException("Unable to perform lock action", e);
                    throw exception;
                }
            }
            finally {
                if (txStarted) {
                    try {
                        statement.execute("COMMIT");
                        LOG.debug(Thread.currentThread().getName() + "> Completed the tx to attempt to set lock_id");
                    }
                    catch (SQLException e) {
                        if (exception == null) {
                            throw new FlywaySqlException("Failed to commit the tx to set lock_id ", e);
                        }
                        LOG.warn(Thread.currentThread().getName() + "> Failed to commit the tx to set lock_id: " + String.valueOf(e));
                    }
                }
            }
        }
        return lockIdToBeReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(long prevLockId, Exception rethrow) {
        Statement statement = null;
        try {
            statement = this.jdbcTemplate.getConnection().createStatement();
            statement.execute("BEGIN");
            ResultSet rs = statement.executeQuery("SELECT lock_id FROM YB_FLYWAY_LOCK_TABLE WHERE table_name = '" + this.tableName + "' FOR UPDATE");
            if (rs.next()) {
                long lockId = rs.getLong("lock_id");
                if (lockId == prevLockId) {
                    statement.executeUpdate("UPDATE YB_FLYWAY_LOCK_TABLE SET lock_id = 0 WHERE table_name = '" + this.tableName + "'");
                } else {
                    String msgLock = "Expected and actual lock_id mismatch. Expected: " + prevLockId + ", Actual: " + lockId;
                    String msg = "Unlock failed but the Flyway operation may have succeeded. Check your Flyway operation before re-trying";
                    LOG.warn(Thread.currentThread().getName() + "> " + msg + "\n" + msgLock);
                    if (rethrow == null) {
                        throw new FlywayException(msg);
                    }
                }
            }
        }
        catch (SQLException e) {
            if (rethrow == null) {
                rethrow = new FlywaySqlException("Unable to perform unlock action for lock_id " + prevLockId, e);
                throw (FlywaySqlException)rethrow;
            }
            LOG.warn("Unable to perform unlock action for lock_id " + prevLockId + ": " + String.valueOf(e));
        }
        finally {
            try {
                statement.execute("COMMIT");
                LOG.debug(Thread.currentThread().getName() + "> Completed the tx to reset lock_id " + prevLockId);
            }
            catch (SQLException e) {
                if (rethrow == null) {
                    throw new FlywaySqlException("Failed to commit unlock action for lock_id " + prevLockId, e);
                }
                LOG.warn("Failed to commit unlock action for lock_id " + prevLockId + ": " + String.valueOf(e));
            }
        }
    }

    public static class YBRetryStrategy {
        private static int numberOfRetries = 50;
        private static boolean unlimitedRetries;
        private int numberOfRetriesRemaining = numberOfRetries;

        public static void setNumberOfRetries(int retries) {
            numberOfRetries = retries;
            unlimitedRetries = retries < 0;
        }

        private boolean hasMoreRetries() {
            return unlimitedRetries || this.numberOfRetriesRemaining > 0;
        }

        private void nextRetry() {
            if (!unlimitedRetries) {
                --this.numberOfRetriesRemaining;
            }
        }

        private int nextWaitInMilliseconds() {
            return 1000;
        }

        public long doWithRetries(SqlCallable<Long> callable, String interruptionMessage, String retriesExceededMessage) throws SQLException {
            long id = 0L;
            while (id == 0L) {
                id = (Long)callable.call();
                try {
                    Thread.sleep(this.nextWaitInMilliseconds());
                }
                catch (InterruptedException e) {
                    throw new FlywayException(interruptionMessage, (Throwable)e);
                }
                if (!this.hasMoreRetries()) {
                    throw new FlywayException(retriesExceededMessage);
                }
                this.nextRetry();
            }
            return id;
        }
    }
}

