/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.snowflake;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.database.snowflake.SnowflakeDatabase;
import org.flywaydb.database.snowflake.SnowflakeSchema;

public class SnowflakeConnection
extends org.flywaydb.core.internal.database.base.Connection<SnowflakeDatabase> {
    private final String originalRole;

    SnowflakeConnection(SnowflakeDatabase database, Connection connection) {
        super((Database)database, connection);
        try {
            this.originalRole = this.jdbcTemplate.queryForString("SELECT CURRENT_ROLE()", new String[0]);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine current role", (Throwable)e);
        }
    }

    protected void doRestoreOriginalState() throws SQLException {
        String currentRole = this.jdbcTemplate.queryForString("SELECT CURRENT_ROLE()", new String[0]);
        if (!this.originalRole.equals(currentRole)) {
            this.jdbcTemplate.execute("USE ROLE " + ((SnowflakeDatabase)this.database).doQuote(this.originalRole), new Object[0]);
        }
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        String schemaName = this.jdbcTemplate.queryForString("SELECT CURRENT_SCHEMA()", new String[0]);
        return schemaName != null ? schemaName : "PUBLIC";
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("USE SCHEMA " + ((SnowflakeDatabase)this.database).doQuote(schema), new Object[0]);
    }

    public Schema getSchema(String name) {
        return new SnowflakeSchema(this.jdbcTemplate, (SnowflakeDatabase)this.database, name);
    }
}

