/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.saphana;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.saphana.SAPHANADatabase;
import org.flywaydb.database.saphana.SAPHANATable;

public class SAPHANASchema
extends Schema<SAPHANADatabase, SAPHANATable> {
    SAPHANASchema(JdbcTemplate jdbcTemplate, SAPHANADatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM SYS.SCHEMAS WHERE SCHEMA_NAME=?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("select count(*) from sys.tables where schema_name = ?", new String[]{this.name});
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.views where schema_name = ?", new String[]{this.name});
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.sequences where schema_name = ?", new String[]{this.name});
        return (objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.synonyms where schema_name = ?", new String[]{this.name})) == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((SAPHANADatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.clean();
        this.jdbcTemplate.execute("DROP SCHEMA " + ((SAPHANADatabase)this.database).quote(new String[]{this.name}) + " RESTRICT", new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (String dropStatement : this.generateDropStatements("SYNONYM")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("TABLE")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("SEQUENCE")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
    }

    private List<String> generateDropStatements(String objectType) throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (String dbObject : this.getDbObjects(objectType)) {
            dropStatements.add("DROP " + objectType + " " + ((SAPHANADatabase)this.database).quote(new String[]{this.name, dbObject}) + " CASCADE");
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForViews() throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (String dbObject : this.getDbObjects("VIEW")) {
            dropStatements.add("DROP VIEW " + ((SAPHANADatabase)this.database).quote(new String[]{this.name, dbObject}));
        }
        return dropStatements;
    }

    private List<String> getDbObjects(String objectType) throws SQLException {
        return this.jdbcTemplate.queryForStringList("select " + objectType + "_NAME from SYS." + objectType + "S where SCHEMA_NAME = ?", new String[]{this.name});
    }

    protected SAPHANATable[] doAllTables() throws SQLException {
        List<String> tableNames = this.getDbObjects("TABLE");
        SAPHANATable[] tables = new SAPHANATable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new SAPHANATable(this.jdbcTemplate, (SAPHANADatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return new SAPHANATable(this.jdbcTemplate, (SAPHANADatabase)this.database, this, tableName);
    }
}

