/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.redshift;

import java.sql.Connection;
import java.util.Map;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.database.redshift.RedshiftDatabase;
import org.flywaydb.database.redshift.RedshiftParser;

public class RedshiftDatabaseType
extends BaseDatabaseType {
    private static final String REDSHIFT_JDBC4_DRIVER = "com.amazon.redshift.jdbc4.Driver";
    private static final String REDSHIFT_JDBC41_DRIVER = "com.amazon.redshift.jdbc41.Driver";

    public String getName() {
        return "Redshift";
    }

    public int getPriority() {
        return 1;
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        if (url.startsWith("jdbc-secretsmanager:redshift:")) {
            throw new FlywayEditionUpgradeRequiredException(Tier.ENTERPRISE, (Tier)null, "jdbc-secretsmanager");
        }
        return url.startsWith("jdbc:redshift:") || url.startsWith("jdbc:p6spy:redshift:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:redshift:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "com.amazon.redshift.jdbc42.Driver";
    }

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)REDSHIFT_JDBC41_DRIVER, (ClassLoader)classLoader)) {
            return REDSHIFT_JDBC41_DRIVER;
        }
        return REDSHIFT_JDBC4_DRIVER;
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        if (databaseProductName.startsWith("PostgreSQL") && databaseProductName.startsWith("PostgreSQL 8") && BaseDatabaseType.getSelectVersionOutput((Connection)connection).contains("Redshift")) {
            return true;
        }
        return databaseProductName.startsWith("Redshift");
    }

    public void setOverridingConnectionProps(Map<String, String> props) {
        props.put("enableFetchRingBuffer", "false");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new RedshiftDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new RedshiftParser(configuration, parsingContext);
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return super.detectPasswordRequiredByUrl(url);
    }
}

