/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.postgresql;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.postgresql.PostgreSQLConfigurationExtension;
import org.flywaydb.database.postgresql.PostgreSQLConnection;

public class PostgreSQLDatabase
extends Database<PostgreSQLConnection> {
    public PostgreSQLDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected PostgreSQLConnection doGetConnection(Connection connection) {
        return new PostgreSQLConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("9.0");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("10", Tier.PREMIUM, configuration);
        this.recommendFlywayUpgradeIfNecessaryForMajorVersion("16");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String tablespace = this.configuration.getTablespace() == null ? "" : " TABLESPACE \"" + this.configuration.getTablespace() + "\"";
        return "CREATE TABLE " + table + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INTEGER,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT now(),\n    \"execution_time\" INTEGER NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n)" + tablespace + ";\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + table + " ADD CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\")" + (String)(this.configuration.getTablespace() != null ? " USING INDEX" + tablespace : "") + ";\nCREATE INDEX \"" + table.getName() + "_s_idx\" ON " + table + " (\"success\")" + tablespace + ";";
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((PostgreSQLConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT current_user", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "TRUE";
    }

    public String getBooleanFalse() {
        return "FALSE";
    }

    public String doQuote(String identifier) {
        return this.getOpenQuote() + StringUtils.replaceAll((String)identifier, (String)this.getCloseQuote(), (String)this.getEscapedQuote()) + this.getCloseQuote();
    }

    public String getEscapedQuote() {
        return "\"\"";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean useSingleConnection() {
        PostgreSQLConfigurationExtension configurationExtension = (PostgreSQLConfigurationExtension)this.configuration.getPluginRegister().getPlugin(PostgreSQLConfigurationExtension.class);
        return !configurationExtension.isTransactionalLock();
    }

    public String getSelectStatement(Table table) {
        return "/*NO LOAD BALANCE*/\nSELECT " + this.quote(new String[]{"installed_rank"}) + "," + this.quote(new String[]{"version"}) + "," + this.quote(new String[]{"description"}) + "," + this.quote(new String[]{"type"}) + "," + this.quote(new String[]{"script"}) + "," + this.quote(new String[]{"checksum"}) + "," + this.quote(new String[]{"installed_on"}) + "," + this.quote(new String[]{"installed_by"}) + "," + this.quote(new String[]{"execution_time"}) + "," + this.quote(new String[]{"success"}) + " FROM " + table + " WHERE " + this.quote(new String[]{"installed_rank"}) + " > ? ORDER BY " + this.quote(new String[]{"installed_rank"});
    }
}

