/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.nc.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Updates;
import com.mongodb.connection.ServerDescription;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.TLSConnectionHelper;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.logging.PreviewFeatureWarning;
import org.flywaydb.core.internal.nc.ConnectionType;
import org.flywaydb.core.internal.nc.DatabaseSupport;
import org.flywaydb.core.internal.nc.DatabaseVersion;
import org.flywaydb.core.internal.nc.DatabaseVersionImpl;
import org.flywaydb.core.internal.nc.MetaData;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.internal.nc.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.AsciiTable;
import org.flywaydb.core.internal.util.DockerUtils;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.UrlUtils;
import org.flywaydb.database.nc.mongodb.MongoshCredential;
import org.flywaydb.nc.NativeConnectorsNonJdbc;
import org.flywaydb.nc.executors.NonJdbcExecutorExecutionUnit;
import org.flywaydb.nc.utils.TemporaryFileUtils;

public class MongoDBDatabase
extends NativeConnectorsNonJdbc {
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private String schemaHistoryTableName = null;
    private MongoshCredential mongoshCredential = null;
    private ClientSession clientSession;
    private Boolean doesSchemaHistoryTableExist;
    private ConnectionString connectionString;

    public DatabaseSupport supportsUrl(String url) {
        if (url.startsWith("mongodb:") || url.startsWith("mongodb+srv:") || url.startsWith("jdbc:mongodb:") || url.startsWith("jdbc:mongodb+srv:")) {
            return new DatabaseSupport(true, 1);
        }
        return new DatabaseSupport(false, 0);
    }

    public List<String> supportedVerbs() {
        return List.of("info", "validate", "migrate", "clean", "undo", "baseline", "repair", "testConnection");
    }

    public boolean isOnByDefault(Configuration configuration) {
        boolean isOSS = "OSS".equals(LicenseGuard.getTierAsString((Configuration)configuration));
        this.initializeConnectionType(configuration, true);
        return isOSS || this.connectionType == ConnectionType.API || this.checkMongoshInstalled(true);
    }

    public boolean supportsTransactions() {
        return !((ServerDescription)this.mongoClient.getClusterDescription().getServerDescriptions().get(0)).isStandAlone();
    }

    public void initialize(ResolvedEnvironment environment, Configuration configuration) {
        PreviewFeatureWarning.logPreviewFeature((String)("Native Connectors for " + this.getDatabaseType()));
        this.initializeConnectionType(configuration, false);
        if (environment.getUrl().startsWith("jdbc:")) {
            LOG.info("JDBC prefix stripped from url: " + this.redactUrl(environment.getUrl()));
            environment.setUrl(environment.getUrl().replaceFirst("jdbc:", ""));
        }
        if (this.connectionType == ConnectionType.EXECUTABLE) {
            this.checkMongoshInstalled(false);
            this.mongoshCredential = new MongoshCredential(environment.getUrl(), environment.getUser(), environment.getPassword());
            this.checkMongoshConnectivity();
        }
        this.connectionString = new ConnectionString(configuration.getUrl());
        if (Boolean.TRUE.equals(this.connectionString.getSslEnabled())) {
            TLSConnectionHelper.get((Configuration)configuration).forEach(x -> x.prepareForTLSConnection(this.connectionString.getConnectionString(), this.connectionType, (NativeConnectorsDatabase)this, configuration));
        } else {
            LOG.debug("SSL is not enabled in the current connection configuration");
        }
        if (this.connectionString.getCredential() != null || configuration.getPassword() == null) {
            this.mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(this.connectionString).applicationName("Flyway by Redgate").build());
        } else {
            String authSource = (String)UrlUtils.extractQueryParams((String)this.connectionString.getConnectionString()).get("authSource");
            String defaultAuthDB = this.connectionString.getDatabase();
            MongoCredential credential = MongoCredential.createCredential((String)configuration.getUser(), (String)(authSource != null ? authSource : (defaultAuthDB != null ? defaultAuthDB : "admin")), (char[])configuration.getPassword().toCharArray());
            this.mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(this.connectionString).applicationName("Flyway by Redgate").credential(credential).build());
        }
        String databaseName = this.getDefaultSchema(configuration);
        this.mongoDatabase = this.mongoClient.getDatabase(databaseName);
        this.currentSchema = this.mongoDatabase.getName();
        this.clientSession = this.mongoClient.startSession();
        this.schemaHistoryTableName = configuration.getTable();
        this.metaData = this.getDatabaseMetaData();
    }

    public void doExecute(NonJdbcExecutorExecutionUnit executionUnit, boolean outputQueryResults) {
        switch (this.connectionType) {
            case API: {
                try {
                    Document result = this.mongoDatabase.runCommand(this.clientSession, (Bson)BsonDocument.parse((String)executionUnit.getScript()));
                    if (result.containsKey((Object)"writeErrors")) {
                        this.handleWriteErrors(result);
                    }
                    if (outputQueryResults) {
                        this.parseResults(result);
                    }
                }
                catch (Exception e) {
                    throw new FlywayException((Throwable)e);
                }
                return;
            }
            case EXECUTABLE: {
                this.doExecuteWithMongosh(executionUnit.getScript(), outputQueryResults);
                return;
            }
        }
        throw new FlywayException("No support for this connection type");
    }

    public MetaData getDatabaseMetaData() {
        Document buildInfo;
        if (this.metaData != null) {
            return this.metaData;
        }
        try {
            buildInfo = this.mongoDatabase.runCommand((Bson)new Document("buildInfo", (Object)1));
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
        String version = buildInfo.getString((Object)"version");
        return new MetaData(this.getDatabaseType(), "MongoDB", (DatabaseVersion)new DatabaseVersionImpl(version), version, this.getCurrentSchema(), this.connectionType);
    }

    public void createSchemaHistoryTable(Configuration configuration) {
        this.mongoDatabase.createCollection(configuration.getTable());
        this.doesSchemaHistoryTableExist = true;
    }

    public boolean schemaHistoryTableExists(String tableName) {
        if (this.doesSchemaHistoryTableExist != null) {
            return this.doesSchemaHistoryTableExist;
        }
        for (Document document : this.mongoDatabase.listCollections()) {
            if (!document.getString((Object)"name").equals(tableName)) continue;
            this.doesSchemaHistoryTableExist = true;
            return true;
        }
        this.doesSchemaHistoryTableExist = false;
        return false;
    }

    public SchemaHistoryModel getSchemaHistoryModel(String tableName) {
        MongoCollection collection = this.mongoDatabase.getCollection(tableName);
        ArrayList<SchemaHistoryItem> items = new ArrayList<SchemaHistoryItem>();
        for (Document document : collection.find()) {
            items.add(SchemaHistoryItem.builder().installedRank(document.getInteger((Object)"installed_rank").intValue()).version(document.getString((Object)"version")).description(document.getString((Object)"description")).type(document.getString((Object)"type")).script(document.getString((Object)"script")).checksum(document.getInteger((Object)"checksum")).installedOn(this.fromTimestampString(document.getString((Object)"installed_on"))).installedBy(document.getString((Object)"installed_by")).executionTime(document.getInteger((Object)"execution_time").intValue()).success(document.getBoolean((Object)"success").booleanValue()).build());
        }
        return new SchemaHistoryModel(items);
    }

    private LocalDateTime fromTimestampString(String timestamp) {
        Object pattern = "yyyy-MM-dd HH:mm:ss.";
        pattern = (String)pattern + "S".repeat(timestamp.length() - ((String)pattern).length());
        return LocalDateTime.parse(timestamp, DateTimeFormatter.ofPattern((String)pattern, Locale.ENGLISH));
    }

    public void appendSchemaHistoryItem(SchemaHistoryItem item, String tableName) {
        Document document = new Document().append("installed_rank", (Object)item.getInstalledRank()).append("version", (Object)item.getVersion()).append("description", (Object)item.getDescription()).append("type", (Object)item.getType()).append("script", (Object)item.getScript()).append("checksum", (Object)item.getChecksum()).append("installed_on", (Object)Timestamp.from(Instant.now()).toString()).append("installed_by", (Object)item.getInstalledBy()).append("execution_time", (Object)item.getExecutionTime()).append("success", (Object)item.isSuccess());
        this.mongoDatabase.getCollection(tableName).insertOne(this.clientSession, (Object)document);
    }

    public Boolean allSchemasEmpty(String[] schemas) {
        return Arrays.stream(schemas).filter(this::isSchemaExists).allMatch(this::isSchemaEmpty);
    }

    public boolean isSchemaExists(String schema) {
        for (String names : this.mongoClient.listDatabaseNames()) {
            if (!names.equals(schema)) continue;
            return true;
        }
        SchemaHistoryModel schemaHistoryModel = this.getSchemaHistoryModel(this.schemaHistoryTableName);
        return schemaHistoryModel.getSchemaHistoryItems().stream().filter(x -> Objects.equals(x.getType(), "SCHEMA")).flatMap(x -> Arrays.stream(x.getScript().replace("\"", "").split(","))).anyMatch(x -> x.equals(schema));
    }

    public void createSchemas(String ... schemas) {
    }

    public void close() throws Exception {
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isSchemaEmpty(String schema) {
        for (Document document : this.mongoClient.getDatabase(schema).listCollections()) {
            if (document.getString((Object)"name").startsWith("system")) continue;
            return false;
        }
        return true;
    }

    protected String getDefaultSchema(Configuration configuration) {
        String defaultSchema = ConfigUtils.getCalculatedDefaultSchema((Configuration)configuration);
        return defaultSchema != null ? defaultSchema : (StringUtils.hasLength((String)this.connectionString.getDatabase()) ? this.connectionString.getDatabase() : "test");
    }

    public String getDatabaseType() {
        return "MongoDB";
    }

    public boolean supportsBatch() {
        return this.connectionType == ConnectionType.API;
    }

    public void doExecuteBatch() {
        if (this.batch.isEmpty()) {
            return;
        }
        this.mongoDatabase.runCommand((Bson)BsonDocument.parse((String)this.batch.stream().map(NonJdbcExecutorExecutionUnit::getScript).collect(Collectors.joining(";"))));
        this.batch.clear();
    }

    public BiFunction<Configuration, ParsingContext, Parser> getParser() {
        return null;
    }

    public String getCurrentUser() {
        return null;
    }

    public void startTransaction() {
        if (this.connectionType == ConnectionType.EXECUTABLE) {
            LOG.warn("Transactions are currently not supported for '.js' Migrations. Migrations will be executed outside of a transaction. Set `executeInTransaction` to false to remove this warning.");
            return;
        }
        if (this.supportsTransactions()) {
            this.clientSession.startTransaction();
        } else {
            LOG.warn("Transactions are not supported on a standalone MongoDB database. Migrations will be executed outside of a transaction. Set `executeInTransaction` to false to remove this warning.");
        }
    }

    public void commitTransaction() {
        if (this.supportsTransactions()) {
            this.clientSession.commitTransaction();
        }
    }

    public void rollbackTransaction() {
        if (this.supportsTransactions()) {
            this.clientSession.abortTransaction();
        }
    }

    public void doCleanSchema(String schema) {
        MongoDatabase schemaDatabase = this.mongoClient.getDatabase(schema);
        schemaDatabase.listCollections().forEach(i -> {
            String name = i.getString((Object)"name");
            if (!name.startsWith("system.")) {
                schemaDatabase.getCollection(name).drop();
            }
        });
    }

    public void doDropSchema(String schema) {
        MongoDatabase schemaDatabase = this.mongoClient.getDatabase(schema);
        schemaDatabase.drop();
    }

    public void removeFailedSchemaHistoryItems(String tableName) {
        Document document = new Document().append("success", (Object)false);
        this.mongoDatabase.getCollection(tableName).deleteMany((Bson)document);
    }

    public void updateSchemaHistoryItem(SchemaHistoryItem item, String tableName) {
        Document query = new Document().append("installed_rank", (Object)item.getInstalledRank());
        Bson updates = Updates.combine((Bson[])new Bson[]{Updates.set((String)"checksum", (Object)item.getChecksum()), Updates.set((String)"description", (Object)item.getDescription()), Updates.set((String)"type", (Object)item.getType())});
        this.mongoDatabase.getCollection(tableName).updateOne((Bson)query, updates);
    }

    private void parseResults(Document result) {
        if (result.containsKey((Object)"cursor")) {
            Document results = (Document)result.get((Object)"cursor");
            List rows = results.getList((Object)"firstBatch", Document.class);
            ArrayList columns = new ArrayList(((Document)rows.stream().findFirst().get()).keySet());
            List<List> processedRows = rows.stream().map(x -> x.values().stream().map(Object::toString).toList()).toList();
            AsciiTable queryResults = new AsciiTable(columns, processedRows, true, "", "");
            LOG.info(queryResults.render());
        }
    }

    private void doExecuteWithMongosh(String executionUnit, boolean outputQueryResults) {
        List<String> commands = this.getMongoshConnectCommands();
        commands.addAll(List.of("--file", TemporaryFileUtils.createTempFile((String)executionUnit, (String)".js")));
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.environment();
        try {
            int exitCode;
            LOG.debug("Executing mongosh");
            Process process = processBuilder.start();
            boolean exited = process.waitFor(5L, TimeUnit.MINUTES);
            if (!exited) {
                throw new FlywayException("Mongosh execution timeout. Consider using smaller migrations");
            }
            if (outputQueryResults) {
                String stdOut = FileUtils.copyToString((Reader)new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8)).strip();
                LOG.info(stdOut);
            }
            if ((exitCode = process.exitValue()) != 0) {
                String stdErr = FileUtils.copyToString((Reader)new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8)).strip();
                throw new FlywayException(stdErr + " (ExitCode: " + exitCode + ")");
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("The filename or extension is too long")) {
                throw new FlywayException("Mongosh execution failed. Consider using smaller migrations");
            }
            throw new FlywayException((Throwable)e);
        }
    }

    private boolean checkMongoshInstalled(boolean silent) {
        List<String> commands = Arrays.asList("mongosh", "--version");
        LOG.debug("Executing " + String.join((CharSequence)" ", commands));
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.environment();
        try {
            processBuilder.start();
        }
        catch (Exception e) {
            if (DockerUtils.isContainer()) {
                if (silent) {
                    return false;
                }
                throw new FlywayException("Mongosh is not installed on this docker image. Please use the Mongo docker image on our repository: https://rd.gt/3OSaoZA");
            }
            if (silent) {
                return false;
            }
            throw new FlywayException("Mongosh is required for .js migrations and is not currently installed. Information on how to install Mongosh can be found here: https://rd.gt/3VudXc6");
        }
        return true;
    }

    private void checkMongoshConnectivity() {
        List<String> commands = this.getMongoshConnectCommands();
        commands.add("--eval");
        commands.add("db.runCommand({ ping: 1 })");
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.environment();
        try {
            Process process = processBuilder.start();
            boolean exited = process.waitFor(1L, TimeUnit.MINUTES);
            if (!exited) {
                throw new FlywayException("Mongosh connection timeout");
            }
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new FlywayException("Mongosh failed to connect to the provided connection URL");
            }
        }
        catch (Exception e) {
            throw new FlywayException(e.getMessage());
        }
    }

    private void initializeConnectionType(Configuration configuration, boolean silent) {
        if (this.connectionType != null) {
            return;
        }
        if (configuration.getSqlMigrationSuffixes().length > 1) {
            if (silent) {
                return;
            }
            throw new FlywayException("Multiple `sqlMigrationSuffixes` currently not supported for MongoDB: " + Arrays.toString(configuration.getSqlMigrationSuffixes()));
        }
        String migrationSuffix = configuration.getSqlMigrationSuffixes()[0];
        if (!".js".equals(migrationSuffix) && !".json".equals(migrationSuffix)) {
            if (silent) {
                return;
            }
            throw new FlywayException("`sqlMigrationSuffixes` is not configured with an accepted MongoDB suffix ('.js' or '.json'): " + migrationSuffix);
        }
        this.connectionType = ".json".equals(migrationSuffix) ? ConnectionType.API : ConnectionType.EXECUTABLE;
    }

    private void handleWriteErrors(Document result) {
        List writeErrors = result.getList((Object)"writeErrors", Document.class);
        String errMsg = ((Document)writeErrors.get(0)).getString((Object)"errmsg");
        throw new FlywayException(errMsg);
    }

    private List<String> getMongoshConnectCommands() {
        ArrayList<String> commands = new ArrayList<String>(List.of("mongosh", this.mongoshCredential.url()));
        if (this.mongoshCredential.username() != null) {
            commands.addAll(List.of("--username", this.mongoshCredential.username()));
        }
        if (this.mongoshCredential.password() != null) {
            commands.addAll(List.of("--password", this.mongoshCredential.password()));
        }
        return commands;
    }
}

