/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.hsqldb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.hsqldb.HSQLDBDatabase;
import org.flywaydb.database.hsqldb.HSQLDBTable;

public class HSQLDBSchema
extends Schema<HSQLDBDatabase, HSQLDBTable> {
    HSQLDBSchema(JdbcTemplate jdbcTemplate, HSQLDBDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM information_schema.system_schemas WHERE table_schem=?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() {
        return ((HSQLDBTable[])this.allTables()).length == 0;
    }

    protected void doCreate() throws SQLException {
        String user = this.jdbcTemplate.queryForString("SELECT USER() FROM (VALUES(0))", new String[0]);
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((HSQLDBDatabase)this.database).quote(new String[]{this.name}) + " AUTHORIZATION " + user, new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((HSQLDBDatabase)this.database).quote(new String[]{this.name}) + " CASCADE", new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (HSQLDBTable table : (HSQLDBTable[])this.allTables()) {
            table.drop();
        }
        for (String statement : this.generateDropStatementsForSequences()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatementsForSequences() throws SQLException {
        List sequenceNames = this.jdbcTemplate.queryForStringList("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = ?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String seqName : sequenceNames) {
            statements.add("DROP SEQUENCE " + ((HSQLDBDatabase)this.database).quote(new String[]{this.name, seqName}));
        }
        return statements;
    }

    protected HSQLDBTable[] doAllTables() throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.SYSTEM_TABLES where TABLE_SCHEM = ? AND TABLE_TYPE = 'TABLE'", new String[]{this.name});
        HSQLDBTable[] tables = new HSQLDBTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new HSQLDBTable(this.jdbcTemplate, (HSQLDBDatabase)this.database, this, (String)tableNames.get(i));
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return new HSQLDBTable(this.jdbcTemplate, (HSQLDBDatabase)this.database, this, tableName);
    }
}

