/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.hsqldb;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.hsqldb.HSQLDBConnection;

public class HSQLDBDatabase
extends Database<HSQLDBConnection> {
    public HSQLDBDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected HSQLDBConnection doGetConnection(Connection connection) {
        return new HSQLDBConnection(this, connection);
    }

    public final void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("1.8");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("2.5", Tier.PREMIUM, configuration);
        this.recommendFlywayUpgradeIfNecessary("2.6");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" BIT NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + table + " ADD CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\");\nCREATE INDEX \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");";
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean useSingleConnection() {
        return true;
    }
}

