/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.db2z;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.community.database.db2z.DB2ZDatabase;
import org.flywaydb.community.database.db2z.DB2ZFunction;
import org.flywaydb.community.database.db2z.DB2ZTable;
import org.flywaydb.community.database.db2z.DB2ZType;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Function;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.base.Type;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class DB2ZSchema
extends Schema<DB2ZDatabase, DB2ZTable> {
    private static final Log LOG = LogFactory.getLog(DB2ZSchema.class);

    DB2ZSchema(JdbcTemplate jdbcTemplate, DB2ZDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM sysibm.sysdatabase WHERE name=?", new String[]{((DB2ZDatabase)this.database).getName()}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("select count(*) from sysibm.systables where dbname = ? AND creator = ?", new String[]{((DB2ZDatabase)this.database).getName(), this.name});
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sysibm.syssequences where schema = ?", new String[]{this.name});
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sysibm.sysindexes where creator = ?", new String[]{this.name});
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sysibm.sysroutines where schema = ?", new String[]{this.name});
        return (objectCount += this.jdbcTemplate.queryForInt("select count(*) from sysibm.systriggers where schema = ?", new String[]{this.name})) == 0;
    }

    protected void doCreate() throws SQLException {
        throw new UnsupportedOperationException("Create Schema - is not supported in db2 on zOS");
    }

    protected void doDrop() throws SQLException {
        throw new UnsupportedOperationException("Drop Schema - is not supported in db2 on zOS");
    }

    /*
     * WARNING - void declaration
     */
    protected void doClean() throws SQLException {
        List<String> list;
        void var3_10;
        List<String> dropVersioningStatements = this.generateDropVersioningStatement();
        if (!dropVersioningStatements.isEmpty()) {
            for (String string : this.generateDropStatements("M", "TABLE")) {
                this.jdbcTemplate.execute(string, new Object[0]);
            }
        }
        for (String string : dropVersioningStatements) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        List<String> disableArchivingStatements = this.generateDisableArchivingStatement();
        if (!disableArchivingStatements.isEmpty()) {
            for (String dropTableStatement : this.generateDropStatements("M", "TABLE")) {
                this.jdbcTemplate.execute(dropTableStatement, new Object[0]);
            }
        }
        for (String disableArchivingStatement : disableArchivingStatements) {
            this.jdbcTemplate.execute(disableArchivingStatement, new Object[0]);
        }
        List<String> list2 = this.generateDropStatements("V", "VIEW");
        while (var3_10.size() != 0) {
            String dropStatement = (String)var3_10.get(0);
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
            List<String> list3 = this.generateDropStatements("V", "VIEW");
        }
        for (String dropStatement : this.generateDropStatements("A", "ALIAS")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (DB2ZTable table : (DB2ZTable[])this.allTables()) {
            table.drop();
        }
        for (String dropStatement : this.generateDropStatements("G", "TABLE")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForRegularTablespace()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForLobTablespace()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForSequences()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForTriggers()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        do {
            list = this.generateDropStatementsForProceduresWithoutDependents();
            for (String dropStatement : list) {
                this.jdbcTemplate.execute(dropStatement, new Object[0]);
            }
        } while (list.size() > 0);
        for (Function function : this.allFunctions()) {
            function.drop();
        }
        for (String dropStatement : this.generateDropStatementsForTypes()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (Type type : this.allTypes()) {
            type.drop();
        }
    }

    private String getSqlId() {
        String sqlId = ((DB2ZDatabase)this.database).getSqlId() == "" ? this.name : ((DB2ZDatabase)this.database).getSqlId();
        return sqlId;
    }

    private List<String> generateDropStatementsForProceduresWithoutDependents() throws SQLException {
        String dropProcGenQuery = "select rtrim(sr.NAME) from SYSIBM.SYSROUTINES sr where sr.CAST_FUNCTION = 'N' and sr.ROUTINETYPE  = 'P' and sr.SCHEMA = '" + this.name + "' and sr.OWNER = '" + this.getSqlId() + "' and not exists ( select * from SYSIBM.SYSDEPENDENCIES sd where sd.BNAME=sr.NAME and sd.BSCHEMA=sr.SCHEMA and sd.DTYPE='O' )";
        return this.buildDropStatements("DROP PROCEDURE", dropProcGenQuery);
    }

    private List<String> generateDropStatementsForSequences() throws SQLException {
        String dropSeqGenQuery = "select rtrim(NAME) from SYSIBM.SYSSEQUENCES where SCHEMA = '" + this.name + "' and SEQTYPE='S' and OWNER = '" + this.getSqlId() + "'";
        return this.buildDropStatements("DROP SEQUENCE", dropSeqGenQuery);
    }

    private List<String> generateDropStatementsForRegularTablespace() throws SQLException {
        String dropTablespaceGenQuery = "select rtrim(NAME) FROM SYSIBM.SYSTABLESPACE where IMPLICIT = 'N' AND DBNAME = '" + ((DB2ZDatabase)this.database).getName() + "' AND CREATOR = '" + this.getSqlId() + "' AND TYPE <> 'O'";
        ArrayList<String> dropStatements = new ArrayList<String>();
        List dbObjects = this.jdbcTemplate.queryForStringList(dropTablespaceGenQuery, new String[0]);
        for (String dbObject : dbObjects) {
            LOG.debug("DROP TABLESPACE " + ((DB2ZDatabase)this.database).quote(new String[]{((DB2ZDatabase)this.database).getName(), dbObject}));
            dropStatements.add("DROP TABLESPACE " + ((DB2ZDatabase)this.database).quote(new String[]{((DB2ZDatabase)this.database).getName(), dbObject}));
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForLobTablespace() throws SQLException {
        String dropTablespaceGenQuery = "select rtrim(NAME) FROM SYSIBM.SYSTABLESPACE where IMPLICIT = 'N' AND DBNAME = '" + ((DB2ZDatabase)this.database).getName() + "' AND CREATOR = '" + this.getSqlId() + "' AND TYPE = 'O'";
        ArrayList<String> dropStatements = new ArrayList<String>();
        List dbObjects = this.jdbcTemplate.queryForStringList(dropTablespaceGenQuery, new String[0]);
        for (String dbObject : dbObjects) {
            LOG.debug("DROP TABLESPACE " + ((DB2ZDatabase)this.database).quote(new String[]{((DB2ZDatabase)this.database).getName(), dbObject}));
            dropStatements.add("DROP TABLESPACE " + ((DB2ZDatabase)this.database).quote(new String[]{((DB2ZDatabase)this.database).getName(), dbObject}));
        }
        return dropStatements;
    }

    private List<String> generateDropStatements(String tableType, String objectType) throws SQLException {
        String dropTablesGenQuery = "select rtrim(NAME) from SYSIBM.SYSTABLES where TYPE='" + tableType + "' and OWNER = '" + this.getSqlId() + "' AND CREATOR = '" + this.name + "'";
        return this.buildDropStatements("DROP " + objectType, dropTablesGenQuery);
    }

    private List<String> generateDropStatementsForTriggers() throws SQLException {
        String dropTrigGenQuery = "select TRIGNAME from SYSIBM.SYSTRIGGERS where SCHEMA = '" + this.name + "' and OWNER = '" + this.getSqlId() + "'";
        LOG.debug(dropTrigGenQuery);
        return this.buildDropStatements("DROP TRIGGER", dropTrigGenQuery);
    }

    private List<String> generateDropStatementsForTypes() throws SQLException {
        String dropProcGenQuery = "select rtrim(NAME) from SYSIBM.SYSROUTINES where CAST_FUNCTION = 'Y'  and ROUTINETYPE  = 'T' and SCHEMA = '" + this.name + "' and OWNER = '" + this.getSqlId() + "'";
        return this.buildDropStatements("DROP PROCEDURE", dropProcGenQuery);
    }

    private List<String> buildDropStatements(String dropPrefix, String query) throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List dbObjects = this.jdbcTemplate.queryForStringList(query, new String[0]);
        for (String dbObject : dbObjects) {
            LOG.debug(dropPrefix + " " + ((DB2ZDatabase)this.database).quote(new String[]{this.name, dbObject}));
            dropStatements.add(dropPrefix + " " + ((DB2ZDatabase)this.database).quote(new String[]{this.name, dbObject}));
        }
        return dropStatements;
    }

    private List<String> generateDropVersioningStatement() throws SQLException {
        DB2ZTable[] versioningTables;
        ArrayList<String> dropVersioningStatements = new ArrayList<String>();
        for (DB2ZTable table : versioningTables = this.findTables("select rtrim(NAME) from SYSIBM.SYSTABLES where VERSIONING_TABLE <> '' and CREATOR = '" + this.name + "' and OWNER = '" + this.getSqlId() + "'", new String[0])) {
            LOG.debug("ALTER TABLE " + table.toString() + " DROP VERSIONING");
            dropVersioningStatements.add("ALTER TABLE " + table.toString() + " DROP VERSIONING");
        }
        return dropVersioningStatements;
    }

    private List<String> generateDisableArchivingStatement() throws SQLException {
        DB2ZTable[] archivingTables;
        ArrayList<String> dropArchivingStatements = new ArrayList<String>();
        for (DB2ZTable table : archivingTables = this.findTables("select rtrim(NAME) from SYSIBM.SYSTABLES where ARCHIVING_TABLE <> '' and CREATOR = '" + this.name + "' and OWNER = '" + this.getSqlId() + "'", new String[0])) {
            LOG.debug("ALTER TABLE " + table.toString() + " DISABLE ARCHIVE");
            dropArchivingStatements.add("ALTER TABLE " + table.toString() + " DISABLE ARCHIVE");
        }
        return dropArchivingStatements;
    }

    private DB2ZTable[] findTables(String sqlQuery, String ... params) throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList(sqlQuery, params);
        DB2ZTable[] tables = new DB2ZTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new DB2ZTable(this.jdbcTemplate, (DB2ZDatabase)this.database, this, (String)tableNames.get(i));
        }
        return tables;
    }

    protected DB2ZTable[] doAllTables() throws SQLException {
        return this.findTables("select rtrim(NAME) from SYSIBM.SYSTABLES where TYPE='T' and CREATOR = '" + this.name + "' and OWNER = '" + this.getSqlId() + "'", new String[0]);
    }

    protected Function[] doAllFunctions() throws SQLException {
        List functionNames = this.jdbcTemplate.queryForStringList("select rtrim(SPECIFICNAME) from SYSIBM.SYSROUTINES where ROUTINETYPE='F' AND ORIGIN IN ('E', 'M', 'Q', 'U') and SCHEMA = '" + this.name + "' and OWNER = '" + this.getSqlId() + "'", new String[0]);
        ArrayList<Function> functions = new ArrayList<Function>();
        for (String functionName : functionNames) {
            functions.add(this.getFunction(functionName, new String[0]));
        }
        return functions.toArray(new Function[0]);
    }

    public Table getTable(String tableName) {
        return new DB2ZTable(this.jdbcTemplate, (DB2ZDatabase)this.database, this, tableName);
    }

    protected Type getType(String typeName) {
        return new DB2ZType(this.jdbcTemplate, (DB2ZDatabase)this.database, this, typeName);
    }

    public Function getFunction(String functionName, String ... args) {
        return new DB2ZFunction(this.jdbcTemplate, this.database, this, functionName, args);
    }
}

