/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.db2z;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.db2z.DB2ZConfigurationExtension;
import org.flywaydb.community.database.db2z.DB2ZConnection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class DB2ZDatabase
extends Database<DB2ZConnection> {
    private String name;

    public DB2ZDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
        DB2ZConfigurationExtension configurationExtension = (DB2ZConfigurationExtension)configuration.getPluginRegister().getPlugin(DB2ZConfigurationExtension.class);
        this.name = configurationExtension.getDatabaseName();
    }

    protected DB2ZConnection doGetConnection(Connection connection) {
        return new DB2ZConnection(this, connection);
    }

    public String getName() {
        return this.name;
    }

    public String getSqlId() {
        DB2ZConfigurationExtension configurationExtension = (DB2ZConfigurationExtension)this.configuration.getPluginRegister().getPlugin(DB2ZConfigurationExtension.class);
        return configurationExtension.getSqlId();
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("12.1");
        this.recommendFlywayUpgradeIfNecessary("13.1");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String tableSpaceName = "SFLYWAY";
        String configurationTablespaceName = this.configuration.getTablespace();
        if (configurationTablespaceName != null) {
            tableSpaceName = configurationTablespaceName;
        }
        String sqlId = this.getSqlId() == "" ? table.getSchema().getName() : this.getSqlId();
        return "SET CURRENT SQLID = '" + sqlId + "';\nSET CURRENT SCHEMA = '" + table.getSchema().getName() + "';\nCREATE TABLESPACE " + tableSpaceName + " IN \"" + this.name + "\" MAXPARTITIONS 1 LOCKSIZE ROW CLOSE YES COMPRESS YES;\nCREATE TABLE " + String.valueOf(table) + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" SMALLINT NOT NULL,\n    CONSTRAINT \"" + table.getName() + "_s\" CHECK (\"success\" in (0, 1))\n) IN \"" + this.name + "\"." + tableSpaceName + ";\nCREATE UNIQUE INDEX \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_pk_idx\" ON " + String.valueOf(table) + " (\"installed_rank\");ALTER TABLE " + String.valueOf(table) + " ADD CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\");\nCREATE INDEX \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + String.valueOf(table) + " (\"success\");" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    public String getSelectStatement(Table table) {
        return super.getSelectStatement(table) + " WITH UR";
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((DB2ZConnection)this.getMainConnection()).getJdbcTemplate().queryForString("select USER from sysibm.sysdummy1", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean useSingleConnection() {
        return true;
    }
}

