/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.databricks;

import java.sql.Connection;
import org.flywaydb.community.database.DatabricksDatabaseExtension;
import org.flywaydb.community.database.databricks.DatabricksDatabase;
import org.flywaydb.community.database.databricks.DatabricksParser;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.ClassUtils;

public class DatabricksDatabaseType
extends BaseDatabaseType
implements CommunityDatabaseType {
    private static final String DATABRICKS_JDBC_DRIVER = "com.databricks.client.jdbc.Driver";
    private static final String DATABRICKS_JDBC41_DRIVER = "com.databricks.client.jdbc41.Driver";

    public String getName() {
        return "Databricks";
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:databricks:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return "com.databricks.client.jdbc42.Driver";
    }

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)DATABRICKS_JDBC41_DRIVER, (ClassLoader)classLoader)) {
            return DATABRICKS_JDBC41_DRIVER;
        }
        return DATABRICKS_JDBC_DRIVER;
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("SparkSQL");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new DatabricksDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new DatabricksParser(configuration, parsingContext);
    }

    public String getPluginVersion(Configuration config) {
        return DatabricksDatabaseExtension.readVersion();
    }
}

