/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.FlywayModel;
import org.flywaydb.core.internal.util.MergeUtils;

public class ConfigurationModel {
    private Map<String, EnvironmentModel> environments = new HashMap<String, EnvironmentModel>();
    private FlywayModel flyway = new FlywayModel();

    public ConfigurationModel defaults() {
        this.flyway.defaults();
        this.environments.put("default", new EnvironmentModel().defaults());
        return this;
    }

    public ConfigurationModel merge(ConfigurationModel otherPojo) {
        ConfigurationModel result = new ConfigurationModel();
        result.flyway = this.flyway != null ? this.flyway.merge(otherPojo.flyway) : otherPojo.flyway;
        result.environments = MergeUtils.merge(this.environments, otherPojo.environments, EnvironmentModel::merge);
        return result;
    }

    public static ConfigurationModel clone(ConfigurationModel pojo) {
        ConfigurationModel basePojo = new ConfigurationModel();
        return basePojo.merge(pojo);
    }

    public Map<String, EnvironmentModel> getEnvironments() {
        return this.environments;
    }

    public FlywayModel getFlyway() {
        return this.flyway;
    }

    public void setEnvironments(Map<String, EnvironmentModel> environments) {
        this.environments = environments;
    }

    public void setFlyway(FlywayModel flyway) {
        this.flyway = flyway;
    }
}

