/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;

public class TomlUtils {
    private static final Log LOG = LogFactory.getLog(TomlUtils.class);

    public static Map<String, String> loadConfigurationFile(File configFile, String encoding) {
        Map valueMap;
        if (!configFile.isFile() || !configFile.canRead()) {
            return new HashMap<String, String>();
        }
        LOG.warn("Loading TOML config file: " + configFile.getAbsolutePath());
        LOG.warn("This is an experimental feature, which is subject to change, and not recommended for use as yet");
        try (FileConfig toml = CommentedFileConfig.builder((File)configFile, (ConfigFormat)TomlFormat.instance()).charset(Charset.forName(encoding)).build();){
            toml.load();
            valueMap = ((Config)toml.valueMap().get("flyway")).valueMap();
        }
        return TomlUtils.flatten(valueMap, "flyway");
    }

    private static Map<String, String> flatten(Map<String, Object> map, String parentKey) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Config) {
                Map<String, String> subTree = TomlUtils.flatten(((Config)value).valueMap(), key);
                for (String subKey : subTree.keySet()) {
                    result.put(parentKey + "." + subKey, subTree.get(subKey));
                }
                continue;
            }
            result.put(parentKey + "." + key, value.toString());
        }
        return result;
    }
}

