/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.reports.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.reports.json.HtmlResultDeserializer;

public class CompositeResultDeserializer
implements JsonDeserializer<CompositeResult<HtmlResult>> {
    private final PluginRegister pluginRegister;

    public CompositeResult<HtmlResult> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        CompositeResult<HtmlResult> result = new CompositeResult<HtmlResult>();
        JsonObject obj = jsonElement.getAsJsonObject();
        JsonElement individualResults = obj.get("individualResults");
        JsonArray irArray = individualResults.getAsJsonArray();
        List<HtmlResultDeserializer> deserializers = this.pluginRegister.getPlugins(HtmlResultDeserializer.class);
        for (Object object : irArray) {
            JsonObject jsonObject = (JsonObject)object;
            deserializers.stream().filter(d -> d.canDeserialize(jsonObject)).findFirst().ifPresent(d -> result.individualResults.add(d.deserialize(jsonObject)));
        }
        return result;
    }

    public CompositeResultDeserializer(PluginRegister pluginRegister) {
        this.pluginRegister = pluginRegister;
    }
}

