/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.beans.Expression;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.UrlUtils;

public class ClassUtils {
    public static <T> T instantiate(String className, ClassLoader classLoader) {
        try {
            return (T)Class.forName(className, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to instantiate class " + className + " : " + e.getMessage(), e);
        }
    }

    public static <T> T instantiate(String className, ClassLoader classLoader, Object ... params) {
        try {
            return (T)new Expression(Class.forName(className, false, classLoader), "new", params).getValue();
        }
        catch (Exception e) {
            throw new FlywayException("Unable to instantiate class " + className + " : " + e.getMessage(), e);
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to instantiate class " + clazz.getName() + " : " + e.getMessage(), e);
        }
    }

    public static <T> List<T> instantiateAll(String[] classes, ClassLoader classLoader) {
        ArrayList<T> clazzes = new ArrayList<T>();
        for (String clazz : classes) {
            if (!StringUtils.hasLength(clazz)) continue;
            clazzes.add(ClassUtils.instantiate(clazz, classLoader));
        }
        return clazzes;
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isImplementationPresent(String serviceName, ClassLoader classLoader) {
        try {
            Class<?> service = classLoader.loadClass(serviceName);
            return ServiceLoader.load(service).iterator().hasNext();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static <I> Class<? extends I> loadClass(Class<I> implementedInterface, String className, ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass(className);
        if (!implementedInterface.isAssignableFrom(clazz)) {
            return null;
        }
        if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isEnum() || clazz.isAnonymousClass()) {
            return null;
        }
        clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return clazz;
    }

    public static String formatThrowable(Throwable e) {
        return "(" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")";
    }

    public static String getLocationOnDisk(Class<?> aClass) {
        ProtectionDomain protectionDomain = aClass.getProtectionDomain();
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || codeSource.getLocation() == null) {
            return null;
        }
        return UrlUtils.decodeURL(codeSource.getLocation().getPath());
    }

    public static String getLibDir(Class<?> clazz) {
        String classLocation = Objects.requireNonNull(ClassUtils.getLocationOnDisk(clazz));
        return new File(classLocation).getParentFile().getParentFile().getAbsolutePath();
    }

    public static String getInstallDir(Class<?> clazz) {
        String path = Objects.requireNonNull(ClassUtils.getLocationOnDisk(clazz));
        return new File(path).getParentFile().getParentFile().getParentFile().getAbsolutePath();
    }

    public static ClassLoader addJarsOrDirectoriesToClasspath(ClassLoader classLoader, List<File> jarFiles) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File jarFile : jarFiles) {
            try {
                urls.add(jarFile.toURI().toURL());
            }
            catch (Exception e) {
                throw new FlywayException("Unable to load " + jarFile.getPath(), e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), classLoader);
    }

    public static String getStaticFieldValue(String className, String fieldName, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(className, true, classLoader);
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to obtain field value " + className + "." + fieldName + " : " + e.getMessage(), e);
        }
    }

    private ClassUtils() {
    }
}

