/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class MergeUtils {
    public static <T> T merge(T a, T b) {
        return b != null ? b : a;
    }

    public static <K, V> Map<K, V> merge(Map<K, V> primary, Map<K, V> overrides, BiFunction<V, V, V> mergeFn) {
        if (primary == null) {
            return overrides;
        }
        HashMap<K, V> result = new HashMap<K, V>(primary);
        if (overrides != null) {
            for (K key : overrides.keySet()) {
                if (primary.containsKey(key)) {
                    V mergedValue = mergeFn.apply(primary.get(key), overrides.get(key));
                    result.replace(key, mergedValue);
                    continue;
                }
                result.put(key, overrides.get(key));
            }
        }
        return result;
    }
}

