/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.Plugin;

public class PluginRegister {
    private static final Log LOG = LogFactory.getLog(PluginRegister.class);
    public final List<Plugin> REGISTERED_PLUGINS = new ArrayList<Plugin>();
    private final ClassLoader CLASS_LOADER = this.getClass().getClassLoader();
    private boolean hasRegisteredPlugins = false;

    public <T extends Plugin> T getPlugin(Class<T> clazz) {
        return (T)((Plugin)this.getPlugins().stream().filter(p -> p.getClass().getCanonicalName().equals(clazz.getCanonicalName())).findFirst().orElse(null));
    }

    public <T extends Plugin> List<T> getPlugins(Class<T> clazz) {
        return this.getPlugins().stream().filter(clazz::isInstance).collect(Collectors.toList());
    }

    public <T extends Plugin> List<T> getLicensedPlugins(Class<T> clazz, Configuration configuration) {
        return this.getPlugins().stream().filter(clazz::isInstance).filter(p -> p.isLicensed(configuration)).collect(Collectors.toList());
    }

    private List<Plugin> getPlugins() {
        this.registerPlugins();
        return this.REGISTERED_PLUGINS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPlugins() {
        List<Plugin> list = this.REGISTERED_PLUGINS;
        synchronized (list) {
            if (this.hasRegisteredPlugins) {
                return;
            }
            for (Plugin plugin : ServiceLoader.load(Plugin.class, this.CLASS_LOADER)) {
                this.REGISTERED_PLUGINS.add(plugin);
            }
            this.hasRegisteredPlugins = true;
        }
    }
}

