/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.parser;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.ParsingContext;

public class PlaceholderReplacingReader
extends FilterReader {
    private final String prefix;
    private final String suffix;
    private final CaseInsensitiveMap placeholders = new CaseInsensitiveMap();
    private final int readAheadLimitAdjustment;
    private final StringBuilder buffer = new StringBuilder();
    private String markBuffer;
    private String replacement;
    private int replacementPos;
    private String markReplacement;
    private int markReplacementPos;

    public PlaceholderReplacingReader(String prefix, String suffix, Map<String, String> placeholders, Reader in) {
        super(in);
        this.prefix = prefix;
        this.suffix = suffix;
        this.placeholders.putAll((Map<? extends String, ? extends String>)placeholders);
        int prefixSuffixLength = prefix.length() + suffix.length();
        int placeholderSizeDifferenceTotal = 0;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            int placeholderLength = prefixSuffixLength + entry.getKey().length();
            int replacementLength = entry.getValue() != null ? entry.getValue().length() : 0;
            placeholderSizeDifferenceTotal += Math.max(0, placeholderLength - replacementLength);
        }
        this.readAheadLimitAdjustment = placeholderSizeDifferenceTotal;
    }

    public static PlaceholderReplacingReader create(Configuration configuration, ParsingContext parsingContext, Reader reader) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        Map<String, String> configurationPlaceholders = configuration.getPlaceholders();
        Map<String, String> parsingContextPlaceholders = parsingContext.getPlaceholders();
        placeholders.putAll(configurationPlaceholders);
        placeholders.putAll(parsingContextPlaceholders);
        return new PlaceholderReplacingReader(configuration.getPlaceholderPrefix(), configuration.getPlaceholderSuffix(), placeholders, reader);
    }

    @Override
    public int read() throws IOException {
        if (this.replacement == null) {
            int r1;
            int r;
            if (this.buffer.length() > 0) {
                char c = this.buffer.charAt(0);
                this.buffer.deleteCharAt(0);
                return c;
            }
            while ((r = super.read()) != -1) {
                this.buffer.append((char)r);
                if (this.buffer.length() < this.prefix.length() && this.endsWith(this.buffer, this.prefix.substring(0, this.buffer.length()))) continue;
            }
            if (!this.endsWith(this.buffer, this.prefix)) {
                if (this.buffer.length() > 0) {
                    char c = this.buffer.charAt(0);
                    this.buffer.deleteCharAt(0);
                    return c;
                }
                return -1;
            }
            this.buffer.delete(0, this.buffer.length());
            StringBuilder placeholderBuilder = new StringBuilder();
            while ((r1 = super.read()) != -1) {
                placeholderBuilder.append((char)r1);
                if (!this.endsWith(placeholderBuilder, this.suffix)) continue;
            }
            for (int i = 0; i < this.suffix.length(); ++i) {
                placeholderBuilder.deleteCharAt(placeholderBuilder.length() - 1);
            }
            String placeholder = placeholderBuilder.toString();
            if (!this.placeholders.containsKey(placeholder)) {
                String canonicalPlaceholder = this.prefix + placeholder + this.suffix;
                if (placeholder.contains("flyway:")) {
                    throw new FlywayException("Failed to populate value for default placeholder: " + canonicalPlaceholder);
                }
                throw new FlywayException("No value provided for placeholder: " + canonicalPlaceholder + ".  Check your configuration!");
            }
            this.replacement = this.placeholders.get(placeholder);
            if (this.replacement == null || this.replacement.length() == 0) {
                this.replacement = null;
                return this.read();
            }
        }
        char result = this.replacement.charAt(this.replacementPos);
        ++this.replacementPos;
        if (this.replacementPos >= this.replacement.length()) {
            this.replacement = null;
            this.replacementPos = 0;
        }
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int r = this.read();
            if (r == -1) {
                return count == 0 ? -1 : count;
            }
            cbuf[off + i] = (char)r;
            ++count;
        }
        return count;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.markBuffer = this.buffer.toString();
        this.markReplacement = this.replacement;
        this.markReplacementPos = this.replacementPos;
        super.mark(readAheadLimit + this.readAheadLimitAdjustment);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.buffer.delete(0, this.buffer.length());
        this.buffer.append(this.markBuffer);
        this.replacement = this.markReplacement;
        this.replacementPos = this.markReplacementPos;
    }

    private boolean endsWith(StringBuilder result, String str) {
        if (result.length() < str.length()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (result.charAt(result.length() - str.length() + i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static class CaseInsensitiveMap
    extends HashMap<String, String> {
        private CaseInsensitiveMap() {
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            for (Map.Entry<? extends String, ? extends String> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public String put(String key, String value) {
            return super.put(key.toLowerCase(), value);
        }

        @Override
        public String get(Object key) {
            return (String)super.get(key.toString().toLowerCase());
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key.toString().toLowerCase());
        }
    }
}

