/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.sqlserver.SQLServerDatabase;
import org.flywaydb.core.internal.database.sqlserver.SQLServerTable;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.RowMapper;

public class SQLServerSchema
extends Schema<SQLServerDatabase, SQLServerTable> {
    private static final Log LOG = LogFactory.getLog(SQLServerSchema.class);
    protected final String databaseName;

    public SQLServerSchema(JdbcTemplate jdbcTemplate, SQLServerDatabase database, String databaseName, String name) {
        super(jdbcTemplate, database, name);
        this.databaseName = databaseName;
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME=?", this.name) > 0;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        boolean empty = this.queryDBObjects(ObjectType.SCALAR_FUNCTION, ObjectType.AGGREGATE, ObjectType.CLR_SCALAR_FUNCTION, ObjectType.CLR_TABLE_VALUED_FUNCTION, ObjectType.TABLE_VALUED_FUNCTION, ObjectType.STORED_PROCEDURE, ObjectType.CLR_STORED_PROCEDURE, ObjectType.USER_TABLE, ObjectType.SYNONYM, ObjectType.SEQUENCE_OBJECT, ObjectType.FOREIGN_KEY, ObjectType.VIEW).isEmpty();
        if (empty) {
            int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM ( SELECT t.name FROM sys.types t INNER JOIN sys.schemas s ON t.schema_id = s.schema_id WHERE t.is_user_defined = 1 AND s.name = ? Union SELECT name FROM sys.assemblies WHERE is_user_defined=1) R", this.name);
            empty = objectCount == 0;
        }
        return empty;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((SQLServerDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.clean();
        this.jdbcTemplate.execute("DROP SCHEMA " + ((SQLServerDatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        List<DBObject> tables = this.queryDBObjects(ObjectType.USER_TABLE);
        for (String statement : this.cleanTriggers()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanForeignKeys(tables)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanDefaultConstraints(tables)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanUniqueConstraints(tables)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanIndexes(tables)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanComputedColumns(tables)) {
            try {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
            catch (SQLException e) {
                LOG.debug("Ignoring dependency-related error: " + e.getMessage());
            }
        }
        for (String statement : this.cleanObjects("FUNCTION", ObjectType.SCALAR_FUNCTION, ObjectType.CLR_SCALAR_FUNCTION, ObjectType.CLR_TABLE_VALUED_FUNCTION, ObjectType.TABLE_VALUED_FUNCTION, ObjectType.INLINED_TABLE_FUNCTION)) {
            try {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
            catch (SQLException e) {
                LOG.debug("Ignoring dependency-related error: " + e.getMessage());
            }
        }
        for (String statement : this.cleanComputedColumns(tables)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanObjects("PROCEDURE", ObjectType.STORED_PROCEDURE, ObjectType.CLR_STORED_PROCEDURE)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanObjects("VIEW", ObjectType.VIEW)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanObjects("FUNCTION", ObjectType.SCALAR_FUNCTION, ObjectType.CLR_SCALAR_FUNCTION, ObjectType.CLR_TABLE_VALUED_FUNCTION, ObjectType.TABLE_VALUED_FUNCTION, ObjectType.INLINED_TABLE_FUNCTION)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        SQLServerTable[] allTables = (SQLServerTable[])this.allTables();
        for (SQLServerTable table : allTables) {
            table.dropSystemVersioningIfPresent();
        }
        for (SQLServerTable table : allTables) {
            table.drop();
        }
        for (String statement : this.cleanObjects("AGGREGATE", ObjectType.AGGREGATE)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanTypes()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanAssemblies()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanSynonyms()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanRules()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanObjects("DEFAULT", ObjectType.DEFAULT_CONSTRAINT)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanObjects("SEQUENCE", ObjectType.SEQUENCE_OBJECT)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    protected List<DBObject> queryDBObjects(ObjectType ... types) throws SQLException {
        return this.queryDBObjectsWithParent(null, types);
    }

    private List<DBObject> queryDBObjectsWithParent(DBObject parent, ObjectType ... types) throws SQLException {
        StringBuilder query = new StringBuilder("SELECT obj.object_id, obj.name FROM sys.objects AS obj LEFT JOIN sys.extended_properties AS eps ON obj.object_id = eps.major_id AND eps.class = 1 AND eps.minor_id = 0 AND eps.name='microsoft_database_tools_support' WHERE SCHEMA_NAME(obj.schema_id) = '" + this.name + "'  AND eps.major_id IS NULL AND obj.is_ms_shipped = 0 AND obj.type IN (");
        boolean first = true;
        for (ObjectType type : types) {
            if (!first) {
                query.append(", ");
            }
            query.append("'").append(type.code).append("'");
            first = false;
        }
        query.append(")");
        if (parent != null) {
            query.append(" AND obj.parent_object_id = ").append(parent.objectId);
        }
        query.append(" order by create_date desc");
        return this.jdbcTemplate.query(query.toString(), new RowMapper<DBObject>(){

            @Override
            public DBObject mapRow(ResultSet rs) throws SQLException {
                return new DBObject(rs.getLong("object_id"), rs.getString("name"));
            }
        }, new Object[0]);
    }

    private List<String> cleanForeignKeys(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            List<DBObject> fks = this.queryDBObjectsWithParent(table, ObjectType.FOREIGN_KEY, ObjectType.CHECK_CONSTRAINT);
            for (DBObject fk : fks) {
                statements.add("ALTER TABLE " + ((SQLServerDatabase)this.database).quote(this.name, table.name) + " DROP CONSTRAINT " + ((SQLServerDatabase)this.database).quote(fk.name));
            }
        }
        return statements;
    }

    private List<String> cleanComputedColumns(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            String tableName = ((SQLServerDatabase)this.database).quote(this.name, table.name);
            List<String> columns = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.computed_columns WHERE object_id=OBJECT_ID(N'" + tableName + "')", new String[0]);
            for (String column : columns) {
                statements.add("ALTER TABLE " + tableName + " DROP COLUMN " + ((SQLServerDatabase)this.database).quote(column));
            }
        }
        return statements;
    }

    private List<String> cleanIndexes(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            String tableName = ((SQLServerDatabase)this.database).quote(this.name, table.name);
            List<String> indexes = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.indexes WHERE object_id=OBJECT_ID(N'" + tableName + "') AND is_primary_key = 0 AND is_unique_constraint = 0 AND name IS NOT NULL", new String[0]);
            for (String index : indexes) {
                statements.add("DROP INDEX " + ((SQLServerDatabase)this.database).quote(index) + " ON " + tableName);
            }
        }
        return statements;
    }

    private List<String> cleanDefaultConstraints(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            String tableName = ((SQLServerDatabase)this.database).quote(this.name, table.name);
            List<String> indexes = this.jdbcTemplate.queryForStringList("SELECT i.name FROM sys.indexes i JOIN sys.index_columns ic on i.index_id = ic.index_id JOIN sys.columns c ON ic.column_id = c.column_id AND i.object_id = c.object_id WHERE i.object_id=OBJECT_ID(N'" + tableName + "') AND is_primary_key = 0 AND is_unique_constraint = 1 AND i.name IS NOT NULL GROUP BY i.name HAVING MAX(CAST(is_rowguidcol AS INT)) = 0 OR MAX(CAST(is_filestream AS INT)) = 0", new String[0]);
            for (String index : indexes) {
                statements.add("ALTER TABLE " + tableName + " DROP CONSTRAINT " + ((SQLServerDatabase)this.database).quote(index));
            }
        }
        return statements;
    }

    private List<String> cleanUniqueConstraints(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            List<DBObject> dfs = this.queryDBObjectsWithParent(table, ObjectType.DEFAULT_CONSTRAINT);
            for (DBObject df : dfs) {
                statements.add("ALTER TABLE " + ((SQLServerDatabase)this.database).quote(this.name, table.name) + " DROP CONSTRAINT " + ((SQLServerDatabase)this.database).quote(df.name));
            }
        }
        return statements;
    }

    private List<String> cleanTypes() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (((SQLServerDatabase)this.database).supportsTypes()) {
            List<String> typeNames = this.jdbcTemplate.queryForStringList("SELECT t.name FROM sys.types t INNER JOIN sys.schemas s ON t.schema_id = s.schema_id WHERE t.is_user_defined = 1 AND s.name = ?", this.name);
            for (String typeName : typeNames) {
                statements.add("DROP TYPE " + ((SQLServerDatabase)this.database).quote(this.name, typeName));
            }
        }
        return statements;
    }

    private List<String> cleanAssemblies() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (((SQLServerDatabase)this.database).supportsAssemblies()) {
            List<String> assemblyNames = this.jdbcTemplate.queryForStringList("SELECT * FROM sys.assemblies WHERE is_user_defined=1", new String[0]);
            for (String assemblyName : assemblyNames) {
                statements.add("DROP ASSEMBLY " + ((SQLServerDatabase)this.database).quote(assemblyName));
            }
        }
        return statements;
    }

    protected List<String> cleanTriggers() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (((SQLServerDatabase)this.database).supportsTriggers()) {
            List<String> triggerNames = this.jdbcTemplate.queryForStringList("SELECT * FROM sys.triggers WHERE is_ms_shipped=0 AND parent_id=0 AND parent_class_desc='DATABASE'", new String[0]);
            for (String triggerName : triggerNames) {
                statements.add("DROP TRIGGER " + ((SQLServerDatabase)this.database).quote(triggerName) + " ON DATABASE");
            }
        }
        return statements;
    }

    protected List<String> cleanSynonyms() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (((SQLServerDatabase)this.database).supportsSynonyms()) {
            statements.addAll(this.cleanObjects("SYNONYM", ObjectType.SYNONYM));
        }
        return statements;
    }

    protected List<String> cleanRules() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (((SQLServerDatabase)this.database).supportsRules()) {
            statements.addAll(this.cleanObjects("RULE", ObjectType.RULE));
        }
        return statements;
    }

    protected List<String> cleanObjects(String dropQualifier, ObjectType ... objectTypes) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        List<DBObject> dbObjects = this.queryDBObjects(objectTypes);
        for (DBObject dbObject : dbObjects) {
            statements.add("DROP " + dropQualifier + " " + ((SQLServerDatabase)this.database).quote(this.name, dbObject.name));
        }
        return statements;
    }

    protected SQLServerTable[] doAllTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (DBObject table : this.queryDBObjects(ObjectType.USER_TABLE)) {
            tableNames.add(table.name);
        }
        SQLServerTable[] tables = new SQLServerTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new SQLServerTable(this.jdbcTemplate, (SQLServerDatabase)this.database, this.databaseName, this, (String)tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new SQLServerTable(this.jdbcTemplate, (SQLServerDatabase)this.database, this.databaseName, this, tableName);
    }

    public static class DBObject {
        public final String name;
        public final long objectId;

        public DBObject(long objectId, String name) {
            assert (name != null);
            this.objectId = objectId;
            this.name = name;
        }
    }

    protected static final class ObjectType
    extends Enum<ObjectType> {
        public static final /* enum */ ObjectType AGGREGATE = new ObjectType("AF");
        public static final /* enum */ ObjectType CHECK_CONSTRAINT = new ObjectType("C");
        public static final /* enum */ ObjectType DEFAULT_CONSTRAINT = new ObjectType("D");
        public static final /* enum */ ObjectType FOREIGN_KEY = new ObjectType("F");
        public static final /* enum */ ObjectType INLINED_TABLE_FUNCTION = new ObjectType("IF");
        public static final /* enum */ ObjectType SCALAR_FUNCTION = new ObjectType("FN");
        public static final /* enum */ ObjectType CLR_SCALAR_FUNCTION = new ObjectType("FS");
        public static final /* enum */ ObjectType CLR_TABLE_VALUED_FUNCTION = new ObjectType("FT");
        public static final /* enum */ ObjectType STORED_PROCEDURE = new ObjectType("P");
        public static final /* enum */ ObjectType CLR_STORED_PROCEDURE = new ObjectType("PC");
        public static final /* enum */ ObjectType RULE = new ObjectType("R");
        public static final /* enum */ ObjectType SYNONYM = new ObjectType("SN");
        public static final /* enum */ ObjectType TABLE_VALUED_FUNCTION = new ObjectType("TF");
        public static final /* enum */ ObjectType ASSEMBLY_DML_TRIGGER = new ObjectType("TA");
        public static final /* enum */ ObjectType SQL_DML_TRIGGER = new ObjectType("TR");
        public static final /* enum */ ObjectType UNIQUE_CONSTRAINT = new ObjectType("UQ");
        public static final /* enum */ ObjectType USER_TABLE = new ObjectType("U");
        public static final /* enum */ ObjectType VIEW = new ObjectType("V");
        public static final /* enum */ ObjectType SEQUENCE_OBJECT = new ObjectType("SO");
        public final String code;
        private static final /* synthetic */ ObjectType[] $VALUES;

        public static ObjectType[] values() {
            return (ObjectType[])$VALUES.clone();
        }

        public static ObjectType valueOf(String name) {
            return Enum.valueOf(ObjectType.class, name);
        }

        private ObjectType(String code) {
            assert (code != null);
            this.code = code;
        }

        static {
            $VALUES = new ObjectType[]{AGGREGATE, CHECK_CONSTRAINT, DEFAULT_CONSTRAINT, FOREIGN_KEY, INLINED_TABLE_FUNCTION, SCALAR_FUNCTION, CLR_SCALAR_FUNCTION, CLR_TABLE_VALUED_FUNCTION, STORED_PROCEDURE, CLR_STORED_PROCEDURE, RULE, SYNONYM, TABLE_VALUED_FUNCTION, ASSEMBLY_DML_TRIGGER, SQL_DML_TRIGGER, UNIQUE_CONSTRAINT, USER_TABLE, VIEW, SEQUENCE_OBJECT};
        }
    }
}

