/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import org.flywaydb.core.api.callback.Warning;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.sqlscript.FlywaySqlScriptException;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;

public class DefaultSqlScriptExecutor
implements SqlScriptExecutor {
    private static final Log LOG = LogFactory.getLog(DefaultSqlScriptExecutor.class);
    private final JdbcTemplate jdbcTemplate;

    public DefaultSqlScriptExecutor(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void execute(SqlScript sqlScript) {
        try (SqlStatementIterator sqlStatementIterator = sqlScript.getSqlStatements();){
            while (sqlStatementIterator.hasNext()) {
                SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                this.executeStatement(this.jdbcTemplate, sqlScript, sqlStatement);
            }
        }
    }

    protected void logStatementExecution(SqlStatement sqlStatement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing SQL: " + sqlStatement.getSql());
        }
    }

    protected void executeStatement(JdbcTemplate jdbcTemplate, SqlScript sqlScript, SqlStatement sqlStatement) {
        this.logStatementExecution(sqlStatement);
        String sql = sqlStatement.getSql() + sqlStatement.getDelimiter();
        Results results = sqlStatement.execute(jdbcTemplate);
        if (results.getException() != null) {
            this.printWarnings(results);
            this.handleException(results, sqlScript, sqlStatement);
            return;
        }
        this.printWarnings(results);
        this.handleResults(results);
    }

    protected void handleResults(Results results) {
        for (Result result : results.getResults()) {
            long updateCount = result.getUpdateCount();
            if (updateCount == -1L) continue;
            this.handleUpdateCount(updateCount);
        }
    }

    private void handleUpdateCount(long updateCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update Count: " + updateCount);
        }
    }

    protected void handleException(Results results, SqlScript sqlScript, SqlStatement sqlStatement) {
        throw new FlywaySqlScriptException(sqlScript.getResource(), sqlStatement, results.getException());
    }

    private void printWarnings(Results results) {
        for (Warning warning : results.getWarnings()) {
            if ("00000".equals(warning.getState())) {
                LOG.info("DB: " + warning.getMessage());
                continue;
            }
            LOG.warn("DB: " + warning.getMessage() + " (SQL State: " + warning.getState() + " - Error Code: " + warning.getCode() + ")");
        }
    }
}

