/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.SqlScriptFlywayCallback;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbClean;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.metadatatable.MetaDataTableImpl;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.ConfigurationInjectionUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.VersionPrinter;
import org.flywaydb.core.internal.util.jdbc.DriverDataSource;
import org.flywaydb.core.internal.util.jdbc.JdbcUtils;
import org.flywaydb.core.internal.util.jdbc.TransactionCallback;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class Flyway
implements FlywayConfiguration {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private Locations locations = new Locations("db/migration");
    private String encoding = "UTF-8";
    private String[] schemaNames = new String[0];
    private String table = "schema_version";
    private MigrationVersion target = MigrationVersion.LATEST;
    private boolean placeholderReplacement = true;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String repeatableSqlMigrationPrefix = "R";
    private String sqlMigrationSeparator = "__";
    private String sqlMigrationSuffix = ".sql";
    private boolean ignoreFutureMigrations = true;
    @Deprecated
    private boolean ignoreFailedFutureMigration;
    private boolean validateOnMigrate = true;
    private boolean cleanOnValidationError;
    private boolean cleanDisabled;
    private MigrationVersion baselineVersion = MigrationVersion.fromVersion("1");
    private String baselineDescription = "<< Flyway Baseline >>";
    private boolean baselineOnMigrate;
    private boolean outOfOrder;
    private FlywayCallback[] callbacks = new FlywayCallback[0];
    private boolean skipDefaultCallbacks;
    private MigrationResolver[] resolvers = new MigrationResolver[0];
    private boolean skipDefaultResolvers;
    private boolean createdDataSource;
    private DataSource dataSource;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private boolean dbConnectionInfoPrinted;

    @Override
    public String[] getLocations() {
        String[] result = new String[this.locations.getLocations().size()];
        for (int i = 0; i < this.locations.getLocations().size(); ++i) {
            result[i] = this.locations.getLocations().get(i).toString();
        }
        return result;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String[] getSchemas() {
        return this.schemaNames;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public MigrationVersion getTarget() {
        return this.target;
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    @Override
    public String getSqlMigrationSuffix() {
        return this.sqlMigrationSuffix;
    }

    public boolean isIgnoreFutureMigrations() {
        return this.ignoreFutureMigrations;
    }

    @Deprecated
    public boolean isIgnoreFailedFutureMigration() {
        LOG.warn("ignoreFailedFutureMigration has been deprecated and will be removed in Flyway 5.0. Use the more generic ignoreFutureMigrations instead.");
        return this.ignoreFailedFutureMigration;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    public boolean isCleanDisabled() {
        return this.cleanDisabled;
    }

    @Override
    public MigrationVersion getBaselineVersion() {
        return this.baselineVersion;
    }

    @Override
    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    @Override
    public MigrationResolver[] getResolvers() {
        return this.resolvers;
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setIgnoreFutureMigrations(boolean ignoreFutureMigrations) {
        this.ignoreFutureMigrations = ignoreFutureMigrations;
    }

    @Deprecated
    public void setIgnoreFailedFutureMigration(boolean ignoreFailedFutureMigration) {
        LOG.warn("ignoreFailedFutureMigration has been deprecated and will be removed in Flyway 5.0. Use the more generic ignoreFutureMigrations instead.");
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setCleanDisabled(boolean cleanDisabled) {
        this.cleanDisabled = cleanDisabled;
    }

    public void setLocations(String ... locations) {
        this.locations = new Locations(locations);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSchemas(String ... schemas) {
        this.schemaNames = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTarget(MigrationVersion target) {
        this.target = target;
    }

    public void setTargetAsString(String target) {
        this.target = MigrationVersion.fromVersion(target);
    }

    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        if (!StringUtils.hasLength(placeholderPrefix)) {
            throw new FlywayException("placeholderPrefix cannot be empty!");
        }
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        if (!StringUtils.hasLength(placeholderSuffix)) {
            throw new FlywayException("placeholderSuffix cannot be empty!");
        }
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.repeatableSqlMigrationPrefix = repeatableSqlMigrationPrefix;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        if (!StringUtils.hasLength(sqlMigrationSeparator)) {
            throw new FlywayException("sqlMigrationSeparator cannot be empty!");
        }
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.createdDataSource = false;
    }

    public void setDataSource(String url, String user, String password, String ... initSqls) {
        this.dataSource = new DriverDataSource(this.classLoader, null, url, user, password, initSqls);
        this.createdDataSource = true;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBaselineVersion(MigrationVersion baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public void setBaselineVersionAsString(String baselineVersion) {
        this.baselineVersion = MigrationVersion.fromVersion(baselineVersion);
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    @Override
    public FlywayCallback[] getCallbacks() {
        return this.callbacks;
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public void setCallbacks(FlywayCallback ... callbacks) {
        this.callbacks = callbacks;
    }

    public void setCallbacksAsClassNames(String ... callbacks) {
        List<FlywayCallback> callbackList = ClassUtils.instantiateAll(callbacks, this.classLoader);
        this.setCallbacks(callbackList.toArray(new FlywayCallback[callbacks.length]));
    }

    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public void setResolvers(MigrationResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    public void setResolversAsClassNames(String ... resolvers) {
        List<MigrationResolver> resolverList = ClassUtils.instantiateAll(resolvers, this.classLoader);
        this.setResolvers(resolverList.toArray(new MigrationResolver[resolvers.length]));
    }

    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    public int migrate() throws FlywayException {
        return this.execute(new Command<Integer>(){

            @Override
            public Integer execute(Connection connectionMetaDataTable, Connection connectionUserObjects, MigrationResolver migrationResolver, DbSupport dbSupport, Schema[] schemas, FlywayCallback[] flywayCallbacks) {
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table));
                if (Flyway.this.validateOnMigrate) {
                    Flyway.this.doValidate(connectionMetaDataTable, dbSupport, migrationResolver, metaDataTable, schemas, flywayCallbacks, true);
                }
                new DbSchemas(connectionMetaDataTable, schemas, metaDataTable).create();
                if (!(metaDataTable.hasSchemasMarker() || metaDataTable.hasBaselineMarker() || metaDataTable.hasAppliedMigrations())) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (Flyway.this.baselineOnMigrate || nonEmptySchemas.isEmpty()) {
                        if (Flyway.this.baselineOnMigrate && !nonEmptySchemas.isEmpty()) {
                            new DbBaseline(connectionMetaDataTable, dbSupport, metaDataTable, schemas[0], Flyway.this.baselineVersion, Flyway.this.baselineDescription, flywayCallbacks).baseline();
                        }
                    } else if (nonEmptySchemas.size() == 1) {
                        Schema schema = (Schema)nonEmptySchemas.get(0);
                        if (schema.allTables().length != 1 || !schema.getTable(Flyway.this.table).exists()) {
                            throw new FlywayException("Found non-empty schema " + schema + " without metadata table! Use baseline()" + " or set baselineOnMigrate to true to initialize the metadata table.");
                        }
                    } else {
                        throw new FlywayException("Found non-empty schemas " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " without metadata table! Use baseline()" + " or set baselineOnMigrate to true to initialize the metadata table.");
                    }
                }
                DbMigrate dbMigrate = new DbMigrate(connectionMetaDataTable, connectionUserObjects, dbSupport, metaDataTable, schemas[0], migrationResolver, Flyway.this.target, Flyway.this.ignoreFutureMigrations, Flyway.this.ignoreFailedFutureMigration, Flyway.this.outOfOrder, flywayCallbacks);
                return dbMigrate.migrate();
            }
        });
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, MigrationResolver migrationResolver, DbSupport dbSupport, Schema[] schemas, FlywayCallback[] flywayCallbacks) {
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table));
                Flyway.this.doValidate(connectionMetaDataTable, dbSupport, migrationResolver, metaDataTable, schemas, flywayCallbacks, false);
                return null;
            }
        });
    }

    private void doValidate(Connection connectionMetaDataTable, DbSupport dbSupport, MigrationResolver migrationResolver, MetaDataTable metaDataTable, Schema[] schemas, FlywayCallback[] flywayCallbacks, boolean pending) {
        String validationError = new DbValidate(connectionMetaDataTable, dbSupport, metaDataTable, schemas[0], migrationResolver, this.target, this.outOfOrder, pending, this.ignoreFutureMigrations, flywayCallbacks).validate();
        if (validationError != null) {
            if (this.cleanOnValidationError) {
                new DbClean(connectionMetaDataTable, dbSupport, metaDataTable, schemas, flywayCallbacks, this.cleanDisabled).clean();
            } else {
                throw new FlywayException("Validate failed. " + validationError);
            }
        }
    }

    public void clean() {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, MigrationResolver migrationResolver, DbSupport dbSupport, Schema[] schemas, FlywayCallback[] flywayCallbacks) {
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table));
                new DbClean(connectionMetaDataTable, dbSupport, metaDataTable, schemas, flywayCallbacks, Flyway.this.cleanDisabled).clean();
                return null;
            }
        });
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public MigrationInfoService execute(final Connection connectionMetaDataTable, Connection connectionUserObjects, MigrationResolver migrationResolver, final DbSupport dbSupport, final Schema[] schemas, FlywayCallback[] flywayCallbacks) {
                try {
                    void object;
                    FlywayCallback[] flywayCallbackArray = flywayCallbacks;
                    int n = flywayCallbackArray.length;
                    boolean bl = false;
                    while (object < n) {
                        final FlywayCallback callback = flywayCallbackArray[object];
                        new TransactionTemplate(connectionMetaDataTable).execute(new TransactionCallback<Object>(){

                            @Override
                            public Object doInTransaction() throws SQLException {
                                dbSupport.changeCurrentSchemaTo(schemas[0]);
                                callback.beforeInfo(connectionMetaDataTable);
                                return null;
                            }
                        });
                        ++object;
                    }
                    dbSupport.changeCurrentSchemaTo(schemas[0]);
                    MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table));
                    MigrationInfoServiceImpl migrationInfoService = new MigrationInfoServiceImpl(migrationResolver, metaDataTable, Flyway.this.target, Flyway.this.outOfOrder, true, true);
                    migrationInfoService.refresh();
                    for (final FlywayCallback callback : flywayCallbacks) {
                        new TransactionTemplate(connectionMetaDataTable).execute(new TransactionCallback<Object>(){

                            @Override
                            public Object doInTransaction() throws SQLException {
                                dbSupport.changeCurrentSchemaTo(schemas[0]);
                                callback.afterInfo(connectionMetaDataTable);
                                return null;
                            }
                        });
                    }
                    MigrationInfoServiceImpl migrationInfoServiceImpl = migrationInfoService;
                    return migrationInfoServiceImpl;
                }
                finally {
                    dbSupport.restoreCurrentSchema();
                }
            }
        });
    }

    public void baseline() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, MigrationResolver migrationResolver, DbSupport dbSupport, Schema[] schemas, FlywayCallback[] flywayCallbacks) {
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table));
                new DbSchemas(connectionMetaDataTable, schemas, metaDataTable).create();
                new DbBaseline(connectionMetaDataTable, dbSupport, metaDataTable, schemas[0], Flyway.this.baselineVersion, Flyway.this.baselineDescription, flywayCallbacks).baseline();
                return null;
            }
        });
    }

    public void repair() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, MigrationResolver migrationResolver, DbSupport dbSupport, Schema[] schemas, FlywayCallback[] flywayCallbacks) {
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table));
                new DbRepair(dbSupport, connectionMetaDataTable, schemas[0], migrationResolver, metaDataTable, flywayCallbacks).repair();
                return null;
            }
        });
    }

    private MigrationResolver createMigrationResolver(DbSupport dbSupport, Scanner scanner) {
        for (MigrationResolver resolver : this.resolvers) {
            ConfigurationInjectionUtils.injectFlywayConfiguration(resolver, this);
        }
        return new CompositeMigrationResolver(dbSupport, scanner, this, this.locations, this.encoding, this.sqlMigrationPrefix, this.repeatableSqlMigrationPrefix, this.sqlMigrationSeparator, this.sqlMigrationSuffix, this.createPlaceholderReplacer(), this.resolvers);
    }

    private PlaceholderReplacer createPlaceholderReplacer() {
        if (this.placeholderReplacement) {
            return new PlaceholderReplacer(this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
        }
        return PlaceholderReplacer.NO_PLACEHOLDERS;
    }

    public void configure(Properties properties) {
        String skipDefaultCallbacksProp;
        String callbacksProp;
        String skipDefaultResolversProp;
        String resolversProp;
        String outOfOrderProp;
        String targetProp;
        String ignoreFailedFutureMigrationProp;
        String ignoreFutureMigrationsProp;
        String baselineOnMigrateProp;
        String baselineDescriptionProp;
        String baselineVersionProp;
        String validateOnMigrateProp;
        String cleanDisabledProp;
        String cleanOnValidationErrorProp;
        String tableProp;
        String schemasProp;
        String encodingProp;
        String sqlMigrationSuffixProp;
        String sqlMigrationSeparatorProp;
        String repeatableSqlMigrationPrefixProp;
        String sqlMigrationPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        String driverProp = this.getValueAndRemoveEntry(props, "flyway.driver");
        String urlProp = this.getValueAndRemoveEntry(props, "flyway.url");
        String userProp = this.getValueAndRemoveEntry(props, "flyway.user");
        String passwordProp = this.getValueAndRemoveEntry(props, "flyway.password");
        if (StringUtils.hasText(urlProp)) {
            this.setDataSource(new DriverDataSource(this.classLoader, driverProp, urlProp, userProp, passwordProp, new String[0]));
        } else if (!StringUtils.hasText(urlProp) && (StringUtils.hasText(driverProp) || StringUtils.hasText(userProp) || StringUtils.hasText(passwordProp))) {
            LOG.warn("Discarding INCOMPLETE dataSource configuration! flyway.url must be set.");
        }
        String locationsProp = this.getValueAndRemoveEntry(props, "flyway.locations");
        if (locationsProp != null) {
            this.setLocations(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((placeholderPrefixProp = this.getValueAndRemoveEntry(props, "flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = this.getValueAndRemoveEntry(props, "flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = this.getValueAndRemoveEntry(props, "flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((repeatableSqlMigrationPrefixProp = this.getValueAndRemoveEntry(props, "flyway.repeatableSqlMigrationPrefix")) != null) {
            this.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
        }
        if ((sqlMigrationSeparatorProp = this.getValueAndRemoveEntry(props, "flyway.sqlMigrationSeparator")) != null) {
            this.setSqlMigrationSeparator(sqlMigrationSeparatorProp);
        }
        if ((sqlMigrationSuffixProp = this.getValueAndRemoveEntry(props, "flyway.sqlMigrationSuffix")) != null) {
            this.setSqlMigrationSuffix(sqlMigrationSuffixProp);
        }
        if ((encodingProp = this.getValueAndRemoveEntry(props, "flyway.encoding")) != null) {
            this.setEncoding(encodingProp);
        }
        if ((schemasProp = this.getValueAndRemoveEntry(props, "flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = this.getValueAndRemoveEntry(props, "flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((cleanOnValidationErrorProp = this.getValueAndRemoveEntry(props, "flyway.cleanOnValidationError")) != null) {
            this.setCleanOnValidationError(Boolean.parseBoolean(cleanOnValidationErrorProp));
        }
        if ((cleanDisabledProp = this.getValueAndRemoveEntry(props, "flyway.cleanDisabled")) != null) {
            this.setCleanDisabled(Boolean.parseBoolean(cleanDisabledProp));
        }
        if ((validateOnMigrateProp = this.getValueAndRemoveEntry(props, "flyway.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(Boolean.parseBoolean(validateOnMigrateProp));
        }
        if ((baselineVersionProp = this.getValueAndRemoveEntry(props, "flyway.baselineVersion")) != null) {
            this.setBaselineVersion(MigrationVersion.fromVersion(baselineVersionProp));
        }
        if ((baselineDescriptionProp = this.getValueAndRemoveEntry(props, "flyway.baselineDescription")) != null) {
            this.setBaselineDescription(baselineDescriptionProp);
        }
        if ((baselineOnMigrateProp = this.getValueAndRemoveEntry(props, "flyway.baselineOnMigrate")) != null) {
            this.setBaselineOnMigrate(Boolean.parseBoolean(baselineOnMigrateProp));
        }
        if ((ignoreFutureMigrationsProp = this.getValueAndRemoveEntry(props, "flyway.ignoreFutureMigrations")) != null) {
            this.setIgnoreFutureMigrations(Boolean.parseBoolean(ignoreFutureMigrationsProp));
        }
        if ((ignoreFailedFutureMigrationProp = this.getValueAndRemoveEntry(props, "flyway.ignoreFailedFutureMigration")) != null) {
            this.setIgnoreFailedFutureMigration(Boolean.parseBoolean(ignoreFailedFutureMigrationProp));
        }
        if ((targetProp = this.getValueAndRemoveEntry(props, "flyway.target")) != null) {
            this.setTarget(MigrationVersion.fromVersion(targetProp));
        }
        if ((outOfOrderProp = this.getValueAndRemoveEntry(props, "flyway.outOfOrder")) != null) {
            this.setOutOfOrder(Boolean.parseBoolean(outOfOrderProp));
        }
        if (StringUtils.hasLength(resolversProp = this.getValueAndRemoveEntry(props, "flyway.resolvers"))) {
            this.setResolversAsClassNames(StringUtils.tokenizeToStringArray(resolversProp, ","));
        }
        if ((skipDefaultResolversProp = this.getValueAndRemoveEntry(props, "flyway.skipDefaultResolvers")) != null) {
            this.setSkipDefaultResolvers(Boolean.parseBoolean(skipDefaultResolversProp));
        }
        if (StringUtils.hasLength(callbacksProp = this.getValueAndRemoveEntry(props, "flyway.callbacks"))) {
            this.setCallbacksAsClassNames(StringUtils.tokenizeToStringArray(callbacksProp, ","));
        }
        if ((skipDefaultCallbacksProp = this.getValueAndRemoveEntry(props, "flyway.skipDefaultCallbacks")) != null) {
            this.setSkipDefaultCallbacks(Boolean.parseBoolean(skipDefaultCallbacksProp));
        }
        HashMap<String, String> placeholdersFromProps = new HashMap<String, String>(this.placeholders);
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = (String)entry.getValue();
            placeholdersFromProps.put(placeholderName, placeholderValue);
            iterator.remove();
        }
        this.setPlaceholders(placeholdersFromProps);
        for (String key : props.keySet()) {
            if (!key.startsWith("flyway.")) continue;
            LOG.warn("Unknown configuration property: " + key);
        }
    }

    private String getValueAndRemoveEntry(Map<String, String> map, String key) {
        String value = map.get(key);
        map.remove(key);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command) {
        T result;
        VersionPrinter.printVersion();
        Connection connectionMetaDataTable = null;
        Connection connectionUserObjects = null;
        try {
            if (this.dataSource == null) {
                throw new FlywayException("Unable to connect to the database. Configure the url, user and password!");
            }
            connectionMetaDataTable = JdbcUtils.openConnection(this.dataSource);
            connectionUserObjects = JdbcUtils.openConnection(this.dataSource);
            DbSupport dbSupport = DbSupportFactory.createDbSupport(connectionMetaDataTable, !this.dbConnectionInfoPrinted);
            this.dbConnectionInfoPrinted = true;
            LOG.debug("DDL Transactions Supported: " + dbSupport.supportsDdlTransactions());
            if (this.schemaNames.length == 0) {
                Schema currentSchema = dbSupport.getOriginalSchema();
                if (currentSchema == null) {
                    throw new FlywayException("Unable to determine schema for the metadata table. Set a default schema for the connection or specify one using the schemas property!");
                }
                this.setSchemas(currentSchema.getName());
            }
            if (this.schemaNames.length == 1) {
                LOG.debug("Schema: " + this.schemaNames[0]);
            } else {
                LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(this.schemaNames));
            }
            Schema[] schemas = new Schema[this.schemaNames.length];
            for (int i = 0; i < this.schemaNames.length; ++i) {
                schemas[i] = dbSupport.getSchema(this.schemaNames[i]);
            }
            Scanner scanner = new Scanner(this.classLoader);
            MigrationResolver migrationResolver = this.createMigrationResolver(dbSupport, scanner);
            HashSet<FlywayCallback> flywayCallbacks = new HashSet<FlywayCallback>(Arrays.asList(this.callbacks));
            if (!this.skipDefaultCallbacks) {
                flywayCallbacks.add(new SqlScriptFlywayCallback(dbSupport, scanner, this.locations, this.createPlaceholderReplacer(), this.encoding, this.sqlMigrationSuffix));
            }
            for (FlywayCallback callback : flywayCallbacks) {
                ConfigurationInjectionUtils.injectFlywayConfiguration(callback, this);
            }
            result = command.execute(connectionMetaDataTable, connectionUserObjects, migrationResolver, dbSupport, schemas, flywayCallbacks.toArray(new FlywayCallback[flywayCallbacks.size()]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeConnection(connectionUserObjects);
            JdbcUtils.closeConnection(connectionMetaDataTable);
            if (this.dataSource instanceof DriverDataSource && this.createdDataSource) {
                ((DriverDataSource)this.dataSource).close();
            }
            throw throwable;
        }
        JdbcUtils.closeConnection(connectionUserObjects);
        JdbcUtils.closeConnection(connectionMetaDataTable);
        if (this.dataSource instanceof DriverDataSource && this.createdDataSource) {
            ((DriverDataSource)this.dataSource).close();
        }
        return result;
    }

    static interface Command<T> {
        public T execute(Connection var1, Connection var2, MigrationResolver var3, DbSupport var4, Schema[] var5, FlywayCallback[] var6);
    }
}

