/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TreeMap;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.UrlUtils;

public class ClassUtils {
    public static <T> T instantiate(String className, ClassLoader classLoader) {
        try {
            return (T)Class.forName(className, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to instantiate class " + className + " : " + e.getMessage(), e);
        }
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isImplementationPresent(String serviceName, ClassLoader classLoader) {
        try {
            Class<?> service = classLoader.loadClass(serviceName);
            return ServiceLoader.load(service).iterator().hasNext();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static <I> Class<? extends I> loadClass(Class<I> implementedInterface, String className, ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass(className);
        if (!implementedInterface.isAssignableFrom(clazz)) {
            return null;
        }
        if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isEnum() || clazz.isAnonymousClass()) {
            return null;
        }
        clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return clazz;
    }

    public static String formatThrowable(Throwable e) {
        return "(" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")";
    }

    public static String getLocationOnDisk(Class<?> aClass) {
        ProtectionDomain protectionDomain = aClass.getProtectionDomain();
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || codeSource.getLocation() == null) {
            return null;
        }
        return UrlUtils.decodeURLSafe(codeSource.getLocation().getPath());
    }

    public static String getLibDir(Class<?> clazz) {
        String classLocation = Objects.requireNonNull(ClassUtils.getLocationOnDisk(clazz));
        return new File(classLocation).getParentFile().getParentFile().getAbsolutePath();
    }

    public static String getInstallDir(Class<?> clazz) {
        String path = Objects.requireNonNull(ClassUtils.getLocationOnDisk(clazz));
        return new File(path).getParentFile().getParentFile().getParentFile().getAbsolutePath();
    }

    public static ClassLoader addJarsOrDirectoriesToClasspath(ClassLoader classLoader, List<File> jarFiles) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File jarFile : jarFiles) {
            try {
                urls.add(jarFile.toURI().toURL());
            }
            catch (Exception e) {
                throw new FlywayException("Unable to load " + jarFile.getPath(), e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), classLoader);
    }

    public static String getStaticFieldValue(String className, String fieldName, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(className, true, classLoader);
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to obtain field value " + className + "." + fieldName + " : " + e.getMessage(), e);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to obtain field value " + obj.getClass().getName() + "." + fieldName + " : " + e.getMessage(), e);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to set field value " + obj.getClass().getName() + "." + fieldName + " : " + e.getMessage(), e);
        }
    }

    public static List<String> getGettableField(Object obj) {
        return ClassUtils.getGettableField(obj, "");
    }

    public static List<String> getGettableField(Object obj, String prefix) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method method : Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().startsWith("get") && Arrays.stream(m.getAnnotations()).noneMatch(a -> a instanceof DoNotMapForLogging) && !m.getName().equals("getClass")).toList()) {
                method.setAccessible(true);
                String name = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
                fields.add(prefix + name);
            }
        }
        return fields;
    }

    public static Map<String, String> getGettableFieldValues(Object obj, String prefix) {
        TreeMap<String, String> fieldValues = new TreeMap<String, String>();
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method method : Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().startsWith("get") && Arrays.stream(m.getAnnotations()).noneMatch(a -> a instanceof DoNotMapForLogging) && !m.getName().equals("getClass")).toList()) {
                try {
                    method.setAccessible(true);
                    String name = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
                    fieldValues.put(prefix + name, method.invoke(obj, new Object[0]).toString());
                }
                catch (Exception exception) {}
            }
        }
        return fieldValues;
    }

    @Generated
    private ClassUtils() {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DoNotMapForLogging {
    }
}

