/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import java.util.Date;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.FlywayExpiredLicenseKeyException;
import org.flywaydb.core.extensibility.FlywayTrialExpiredException;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;
import org.flywaydb.core.internal.license.FlywayPermit;

public class LicenseGuard {
    private static final Log LOG = LogFactory.getLog(LicenseGuard.class);

    public static void guard(Configuration configuration, List<Tier> editions, String featureName) {
        FlywayPermit flywayPermit = LicenseGuard.getPermit(configuration);
        if (flywayPermit.getPermitExpiry() != null && flywayPermit.getPermitExpiry().before(new Date()) || flywayPermit.getContractExpiry() != null && flywayPermit.getContractExpiry().before(new Date())) {
            if (flywayPermit.isTrial()) {
                throw new FlywayTrialExpiredException(flywayPermit.getTier(), featureName);
            }
            throw new FlywayExpiredLicenseKeyException(flywayPermit.getTier(), featureName);
        }
        for (Tier tier : editions) {
            if (flywayPermit.getTier() != tier) continue;
            return;
        }
        throw new FlywayEditionUpgradeRequiredException(editions.get(0), flywayPermit.getTier(), featureName);
    }

    public static boolean isLicensed(Configuration configuration, List<Tier> editions) {
        FlywayPermit flywayPermit = LicenseGuard.getPermit(configuration);
        if (flywayPermit.getPermitExpiry() != null && flywayPermit.getPermitExpiry().before(new Date()) || flywayPermit.getContractExpiry() != null && flywayPermit.getContractExpiry().before(new Date())) {
            return false;
        }
        for (Tier tier : editions) {
            if (flywayPermit.getTier() != tier) continue;
            return true;
        }
        return false;
    }

    public static FlywayPermit getPermit(Configuration configuration) {
        return LicenseGuard.getPermit(configuration, true);
    }

    public static Tier getTier(Configuration configuration) {
        return LicenseGuard.getPermit(configuration, true).getTier();
    }

    public static String getTierAsString(Configuration configuration) {
        return Tier.asString(LicenseGuard.getPermit(configuration, true).getTier());
    }

    public static FlywayPermit getPermit(Configuration configuration, boolean fromCache) {
        return new FlywayPermit("Anonymous", null, null, false, false);
    }

    public static void dropCache() {
    }
}

