/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentProvisioner;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentProvisionerNone;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContextImpl;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;
import org.flywaydb.core.internal.plugin.PluginRegister;

public class EnvironmentResolver {
    private final Map<String, PropertyResolver> propertyResolvers;
    private final Map<String, EnvironmentProvisioner> environmentProvisioners;

    public EnvironmentResolver(Map<String, PropertyResolver> propertyResolvers, Map<String, EnvironmentProvisioner> environmentProvisioners) {
        this.propertyResolvers = propertyResolvers;
        this.environmentProvisioners = environmentProvisioners;
    }

    public ResolvedEnvironment resolve(String environmentName, EnvironmentModel environment, Configuration configuration, ProgressLogger progress) {
        return this.resolve(environmentName, environment, ProvisionerMode.Provision, configuration, progress);
    }

    public ResolvedEnvironment resolve(String environmentName, EnvironmentModel environment, ProvisionerMode mode, Configuration configuration, ProgressLogger progress) {
        Map<String, ConfigurationExtension> resolverConfigs = this.getEnvironmentPluginConfigMap(environment, configuration.getPluginRegister());
        PropertyResolverContextImpl context = new PropertyResolverContextImpl(environmentName, configuration, this.propertyResolvers, resolverConfigs);
        ResolvedEnvironment result = new ResolvedEnvironment();
        result.setDriver(environment.getDriver());
        result.setConnectRetries(environment.getConnectRetries());
        result.setConnectRetriesInterval(environment.getConnectRetriesInterval());
        result.setInitSql(environment.getInitSql());
        result.setSchemas(environment.getSchemas());
        result.setJarDirs(environment.getJarDirs());
        progress.pushSteps(2);
        ProgressLogger provisionProgress = progress.subTask("provision");
        ProgressLogger resolveProgress = progress.subTask("resolve");
        EnvironmentProvisioner provisioner = this.getProvisioner(environment.getProvisioner(), context, provisionProgress);
        if (mode == ProvisionerMode.Provision) {
            progress.log("Provisioning environment " + environmentName + " with " + provisioner.getName());
            provisioner.preProvision(context, provisionProgress);
        } else if (mode == ProvisionerMode.Reprovision) {
            progress.log("Reprovisioning environment " + environmentName + " with " + provisioner.getName());
            provisioner.preReprovision(context, provisionProgress);
        }
        progress.log("Resolving environment properties " + environmentName);
        if (environment.getJdbcProperties() != null) {
            HashMap<String, String> jdbcResolvedProps = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : environment.getJdbcProperties().entrySet()) {
                jdbcResolvedProps.put(entry.getKey(), context.resolveValue(entry.getValue(), resolveProgress));
            }
            result.setJdbcProperties(jdbcResolvedProps);
        }
        result.setPassword(context.resolveValue(environment.getPassword(), resolveProgress));
        result.setUser(context.resolveValue(environment.getUser(), resolveProgress));
        result.setUrl(context.resolveValue(environment.getUrl(), resolveProgress));
        result.setToken(context.resolveValue(environment.getToken(), resolveProgress));
        if (mode == ProvisionerMode.Provision) {
            progress.log("Provisioning environment " + environmentName + " with " + provisioner.getName());
            provisioner.postProvision(context, result, provisionProgress);
        } else if (mode == ProvisionerMode.Reprovision) {
            progress.log("Reprovisioning environment " + environmentName + " with " + provisioner.getName());
            provisioner.postReprovision(context, result, provisionProgress);
        }
        return result;
    }

    private EnvironmentProvisioner getProvisioner(String provisionerName, PropertyResolverContext context, ProgressLogger progress) {
        String name = context.resolveValue(provisionerName, progress);
        if (name != null) {
            if (!this.environmentProvisioners.containsKey(provisionerName)) {
                throw new FlywayException("Unknown provisioner '" + provisionerName + "' for environment " + context.getEnvironmentName(), ErrorCode.CONFIGURATION);
            }
            return this.environmentProvisioners.get(provisionerName);
        }
        return new EnvironmentProvisionerNone();
    }

    private Map<String, ConfigurationExtension> getEnvironmentPluginConfigMap(EnvironmentModel environmentModel, PluginRegister pluginRegister) {
        if (environmentModel.getResolvers() != null) {
            return environmentModel.getResolvers().keySet().stream().collect(Collectors.toMap(k -> k, v -> this.getResolverConfig(environmentModel, pluginRegister, (String)v)));
        }
        return null;
    }

    private ConfigurationExtension getResolverConfig(EnvironmentModel environmentModel, PluginRegister pluginRegister, String key) {
        Class clazz = this.getResolverConfigClassFromKey(pluginRegister, key);
        if (clazz != null) {
            Map<String, Object> data = environmentModel.getResolvers().get(key);
            return (ConfigurationExtension)new ObjectMapper().convertValue(data, clazz);
        }
        throw new FlywayException("Unable to find resolver: " + key);
    }

    private Class getResolverClassFromKey(PluginRegister pluginRegister, String key) {
        Plugin plugin = pluginRegister.getPlugins(EnvironmentProvisioner.class).stream().filter(p -> p.getName().equalsIgnoreCase(key)).findFirst().orElse(null);
        if (plugin == null) {
            plugin = pluginRegister.getPlugins(PropertyResolver.class).stream().filter(p -> p.getName().equalsIgnoreCase(key)).findFirst().orElse(null);
        }
        if (plugin != null) {
            return plugin.getClass();
        }
        throw new FlywayException("Unable to find resolver: " + key);
    }

    private Class getResolverConfigClassFromKey(PluginRegister pluginRegister, String key) {
        Class resolverClass = this.getResolverClassFromKey(pluginRegister, key);
        if (resolverClass == null) {
            return null;
        }
        Object plugin = pluginRegister.getPlugin(resolverClass);
        if (plugin instanceof EnvironmentProvisioner) {
            EnvironmentProvisioner environmentProvisioner = (EnvironmentProvisioner)plugin;
            return environmentProvisioner.getConfigClass();
        }
        if (plugin instanceof PropertyResolver) {
            PropertyResolver propertyResolver = (PropertyResolver)plugin;
            return propertyResolver.getConfigClass();
        }
        throw new FlywayException("Unable to find resolver: " + key);
    }
}

