/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.utils;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.internal.util.HtmlUtils;
import org.flywaydb.core.internal.util.JsonUtils;

public class OperationsReportUtils {
    private static final Log LOG = LogFactory.getLog(OperationsReportUtils.class);
    public static final String DEFAULT_REPORT_FILENAME = "report";
    public static final String JSON_REPORT_EXTENSION = ".json";
    public static final String HTML_REPORT_EXTENSION = ".html";
    public static final String HTM_REPORT_EXTENSION = ".htm";
    private static final Pattern REPORT_FILE_PATTERN = Pattern.compile("\\.html?$");

    public static String getBaseFilename(String filename) {
        if (REPORT_FILE_PATTERN.matcher(filename).find()) {
            return filename.replaceAll(REPORT_FILE_PATTERN.pattern(), "");
        }
        return filename;
    }

    public static String createHtmlReport(Configuration configuration, CompositeResult<HtmlResult> htmlCompositeResult, String tmpHtmlReportFilename) {
        return HtmlUtils.toHtmlFile((String)tmpHtmlReportFilename, htmlCompositeResult, (Configuration)configuration);
    }

    public static String createJsonReport(CompositeResult<HtmlResult> htmlCompositeResult, String tmpJsonReportFilename) {
        return JsonUtils.jsonToFile((String)tmpJsonReportFilename, htmlCompositeResult);
    }

    public static OperationResult filterHtmlResults(OperationResult result) {
        if (result instanceof CompositeResult) {
            List filteredResults = ((CompositeResult)result).individualResults.stream().map(OperationsReportUtils::filterHtmlResults).filter(Objects::nonNull).collect(Collectors.toList());
            if (filteredResults.isEmpty()) {
                return null;
            }
            CompositeResult htmlCompositeResult = new CompositeResult();
            htmlCompositeResult.individualResults.addAll(filteredResults);
            return htmlCompositeResult;
        }
        if (result instanceof HtmlResult) {
            return result;
        }
        return null;
    }

    public static Exception getAggregateExceptions(OperationResult result) {
        if (result instanceof CompositeResult) {
            Exception aggregate = null;
            List exceptions = ((CompositeResult)result).individualResults.stream().map(OperationsReportUtils::getAggregateExceptions).filter(Objects::nonNull).collect(Collectors.toList());
            for (Exception e : exceptions) {
                if (aggregate == null) {
                    aggregate = e;
                    continue;
                }
                aggregate.addSuppressed(e);
            }
            return aggregate;
        }
        if (result instanceof HtmlResult) {
            return ((HtmlResult)result).exceptionObject;
        }
        return null;
    }

    public static CompositeResult<HtmlResult> flattenHtmlResults(OperationResult result) {
        CompositeResult htmlCompositeResult = new CompositeResult();
        if (result instanceof CompositeResult) {
            List htmlResults = ((CompositeResult)result).individualResults.stream().map(OperationsReportUtils::flattenHtmlResults).flatMap(r -> r.individualResults.stream()).collect(Collectors.toList());
            htmlCompositeResult.individualResults.addAll(htmlResults);
        } else if (result instanceof HtmlResult) {
            htmlCompositeResult.individualResults.add((HtmlResult)result);
        }
        return htmlCompositeResult;
    }

    private OperationsReportUtils() {
    }
}

