/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.VersionPrinter;

public class RedgateUpdateChecker {
    private static final String UPDATE_CHECK_ENDPOINT = "https://repo.flywaydb.org/update-check";
    private static final String REDGATE_SERVER_ADDRESS = "https://repo.flywaydb.org";
    private static final Log LOG = LogFactory.getLog(RedgateUpdateChecker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUpdateCheckMessage(String jdbcUrl) {
        String message = "";
        if (!RedgateUpdateChecker.isRedgateServerReachable()) {
            LOG.debug("Could not reach Redgate server for update check.");
            return message;
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)new URL(UPDATE_CHECK_ENDPOINT).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; utf-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            String jsonPayload = RedgateUpdateChecker.getJsonPayload(jdbcUrl);
            RedgateUpdateChecker.putJsonInConnectionRequestBody((HttpsURLConnection)connection, jsonPayload);
            StringBuilder response = new StringBuilder();
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = rd.readLine()) != null) {
                    response.append(line).append('\r');
                }
            }
            message = ((UpdateCheckResponse)new Gson().fromJson((String)response.toString(), UpdateCheckResponse.class)).message;
        }
        catch (Exception e) {
            LOG.debug("Failed to perform update check: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return message;
    }

    private static boolean isRedgateServerReachable() {
        HttpURLConnection connection = null;
        try {
            HttpsURLConnection.setFollowRedirects(false);
            connection = (HttpsURLConnection)new URL(REDGATE_SERVER_ADDRESS).openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(1000);
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static void putJsonInConnectionRequestBody(HttpsURLConnection connection, String jsonPayload) throws IOException {
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
    }

    private static String getJsonPayload(String jdbcUrl) throws Exception {
        String version = VersionPrinter.getVersion();
        String operatingSystem = System.getProperty("os.name");
        JsonObject json = new JsonObject();
        json.addProperty("currentVersion", version);
        json.addProperty("operatingSystem", operatingSystem);
        json.addProperty("fingerprint", RedgateUpdateChecker.getFingerprint(operatingSystem, jdbcUrl));
        return new Gson().toJson((JsonElement)json);
    }

    private static String getFingerprint(String operatingSystem, String jdbcUrl) throws Exception {
        if (RedgateUpdateChecker.isEmpty(operatingSystem) || RedgateUpdateChecker.isEmpty(jdbcUrl)) {
            throw new Exception("All parameters required for getFingerprint - operatingSystem: " + RedgateUpdateChecker.isEmpty(operatingSystem) + ", jdbcUrl: " + RedgateUpdateChecker.isEmpty(jdbcUrl));
        }
        byte[] hashedId = operatingSystem.getBytes(StandardCharsets.UTF_8);
        hashedId = RedgateUpdateChecker.getHashed(operatingSystem.getBytes(StandardCharsets.UTF_8), hashedId);
        hashedId = RedgateUpdateChecker.getHashed(jdbcUrl.getBytes(StandardCharsets.UTF_8), hashedId);
        hashedId = RedgateUpdateChecker.getHashed(System.getProperty("user.dir").getBytes(StandardCharsets.UTF_8), hashedId);
        List<byte[]> hardwareAddresses = RedgateUpdateChecker.getHardwareAddresses();
        if (hardwareAddresses.size() == 0) {
            throw new Exception("No hardware addresses found when creating fingerprint");
        }
        for (byte[] hardwareAddress : hardwareAddresses) {
            hashedId = RedgateUpdateChecker.getHashed(hardwareAddress, hashedId);
        }
        return RedgateUpdateChecker.hashToString(hashedId);
    }

    private static List<byte[]> getHardwareAddresses() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        if (networkInterfaces == null) {
            return new ArrayList<byte[]>();
        }
        return Collections.list(networkInterfaces).stream().map(RedgateUpdateChecker::extractHardwareAddress).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static byte[] extractHardwareAddress(NetworkInterface networkInterface) {
        try {
            return networkInterface.getHardwareAddress();
        }
        catch (SocketException e) {
            return null;
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static byte[] getHashed(byte[] salt, byte[] digest) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        md.update(salt);
        return md.digest(digest);
    }

    private static String hashToString(byte[] hashedId) {
        CharSequence[] hexadecimal = new String[hashedId.length];
        for (int i = 0; i < hexadecimal.length; ++i) {
            hexadecimal[i] = String.format("%02X", hashedId[i]);
        }
        return String.join((CharSequence)"", hexadecimal);
    }

    private static class UpdateCheckResponse {
        public String message;

        private UpdateCheckResponse() {
        }
    }
}

