/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.commandline.ConsoleLog;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.StringUtils;

class CommandLineArguments {
    private static String DEBUG_FLAG = "-X";
    private static String QUIET_FLAG = "-q";
    private static String SUPPRESS_PROMPT_FLAG = "-n";
    private static String PRINT_VERSION_AND_EXIT_FLAG = "-v";
    private static String JSON_FLAG = "-json";
    private static String PRINT_USAGE_FLAG = "-?";
    private static String COMMUNITY_FLAG = "-community";
    private static String PRO_FLAG = "-pro";
    private static String ENTERPRISE_FLAG = "-enterprise";
    private static String LOG_FILE = "logFile";
    private static String CONFIG_FILE_ENCODING = "configFileEncoding";
    private static String CONFIG_FILES = "configFiles";
    private static List<String> VALID_OPERATIONS_AND_FLAGS = Arrays.asList(DEBUG_FLAG, QUIET_FLAG, SUPPRESS_PROMPT_FLAG, PRINT_VERSION_AND_EXIT_FLAG, JSON_FLAG, PRINT_USAGE_FLAG, COMMUNITY_FLAG, PRO_FLAG, ENTERPRISE_FLAG, "help", "migrate", "clean", "info", "validate", "undo", "baseline", "repair");
    private final String[] args;

    private CommandLineArguments(String[] args) {
        this.args = args;
    }

    static CommandLineArguments createFromArguments(String[] args) {
        CommandLineArguments.validate(args);
        return new CommandLineArguments(args);
    }

    private static boolean isFlagSet(String[] args, String flag) {
        for (String arg : args) {
            if (!flag.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static String getArgumentValue(String argName, String[] allArgs) {
        for (String arg : allArgs) {
            if (!arg.startsWith("-" + argName + "=")) continue;
            return CommandLineArguments.parseConfigurationOptionValueFromArg(arg);
        }
        return "";
    }

    private static String parseConfigurationOptionValueFromArg(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static List<String> getOperationsFromArgs(String[] args) {
        ArrayList<String> operations = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            operations.add(arg);
        }
        return operations;
    }

    private static List<String> getConfigFilesFromArgs(String[] args) {
        String configFilesCommaSeparatedList = CommandLineArguments.getArgumentValue(CONFIG_FILES, args);
        return Arrays.asList(StringUtils.tokenizeToStringArray((String)configFilesCommaSeparatedList, (String)","));
    }

    private static Map<String, String> getConfigurationFromArgs(String[] args) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (String arg : args) {
            String configurationOptionName;
            if (!CommandLineArguments.isConfigurationArg(arg) || CommandLineArguments.isConfigurationOptionIgnored(configurationOptionName = CommandLineArguments.getConfigurationOptionNameFromArg(arg))) continue;
            configuration.put("flyway." + configurationOptionName, CommandLineArguments.parseConfigurationOptionValueFromArg(arg));
        }
        return configuration;
    }

    private static boolean isConfigurationOptionIgnored(String configurationOptionName) {
        return LOG_FILE.equals(configurationOptionName);
    }

    private static String getConfigurationOptionNameFromArg(String arg) {
        int index = arg.indexOf("=");
        return arg.substring(1, index);
    }

    private static boolean isConfigurationArg(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    private static void validate(String[] args) {
        for (String arg : args) {
            if (CommandLineArguments.isConfigurationArg(arg) || VALID_OPERATIONS_AND_FLAGS.contains(arg)) continue;
            throw new FlywayException("Invalid argument: " + arg);
        }
    }

    boolean shouldSuppressPrompt() {
        return CommandLineArguments.isFlagSet(this.args, SUPPRESS_PROMPT_FLAG);
    }

    boolean shouldPrintVersionAndExit() {
        return CommandLineArguments.isFlagSet(this.args, PRINT_VERSION_AND_EXIT_FLAG);
    }

    boolean shouldOutputJson() {
        return CommandLineArguments.isFlagSet(this.args, JSON_FLAG);
    }

    boolean shouldPrintUsage() {
        return CommandLineArguments.isFlagSet(this.args, PRINT_USAGE_FLAG) || this.getOperations().isEmpty();
    }

    ConsoleLog.Level getLogLevel() {
        if (CommandLineArguments.isFlagSet(this.args, QUIET_FLAG)) {
            return ConsoleLog.Level.WARN;
        }
        if (CommandLineArguments.isFlagSet(this.args, DEBUG_FLAG)) {
            return ConsoleLog.Level.DEBUG;
        }
        return ConsoleLog.Level.INFO;
    }

    boolean hasOperation(String operation) {
        return this.getOperations().contains(operation);
    }

    List<String> getOperations() {
        return CommandLineArguments.getOperationsFromArgs(this.args);
    }

    List<String> getConfigFiles() {
        return CommandLineArguments.getConfigFilesFromArgs(this.args);
    }

    String getLogFilepath() {
        return CommandLineArguments.getArgumentValue(LOG_FILE, this.args);
    }

    boolean isLogFilepathSet() {
        return this.getLogFilepath() != null && !this.getLogFilepath().isEmpty();
    }

    String getConfigFileEncoding() {
        return CommandLineArguments.getArgumentValue(CONFIG_FILE_ENCODING, this.args);
    }

    boolean isConfigFileEncodingSet() {
        return this.getConfigFileEncoding() != null && !this.getConfigFileEncoding().isEmpty();
    }

    Map<String, String> getConfiguration() {
        return CommandLineArguments.getConfigurationFromArgs(this.args);
    }
}

