/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.flywaydb.commandline.PrintStreamLog;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;

class FileLogCreator
implements LogCreator {
    private final PrintStreamLog.Level level;
    private final String filePath;

    public FileLogCreator(PrintStreamLog.Level level, String filePath) {
        this.level = level;
        this.filePath = filePath;
    }

    public Log createLogger(Class<?> clazz) {
        PrintStream filePrintStream = this.getFilePrintStream();
        return new PrintStreamLog(this.level, filePrintStream, filePrintStream);
    }

    private PrintStream getFilePrintStream() {
        try {
            return new PrintStream(this.filePath);
        }
        catch (FileNotFoundException e) {
            throw new FlywayException("Could not open file " + this.filePath + " for logging.");
        }
    }
}

