/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.logging;

import java.util.ArrayList;
import lombok.Generated;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.logging.console.ConsoleLogCreator;
import org.flywaydb.commandline.logging.file.FileLogCreator;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.logging.JsonLogCreator;
import org.flywaydb.core.internal.logging.multi.MultiLogCreator;

public class LoggingUtils {
    public static LogCreator getLogCreator(CommandLineArguments commandLineArguments) {
        if (commandLineArguments.shouldOutputJson()) {
            return new JsonLogCreator();
        }
        if (commandLineArguments.hasOperation("info") && commandLineArguments.isFilterOnMigrationIds()) {
            return MultiLogCreator.empty();
        }
        ArrayList<Object> logCreators = new ArrayList<Object>();
        logCreators.add(new ConsoleLogCreator(commandLineArguments));
        if (commandLineArguments.isOutputFileSet()) {
            logCreators.add(new FileLogCreator(commandLineArguments));
        }
        return new MultiLogCreator(logCreators);
    }

    public static Log initLogging(Class<?> clazz, CommandLineArguments commandLineArguments) {
        LogFactory.setFallbackLogCreator((LogCreator)LoggingUtils.getLogCreator(commandLineArguments));
        return LogFactory.getLog(clazz);
    }

    @Generated
    private LoggingUtils() {
    }
}

