/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.VersionPrinter;

class MavenVersionChecker {
    @Generated
    private static final Log LOG = LogFactory.getLog(MavenVersionChecker.class);
    private final String flywayUrl;
    private final Supplier<MigrationVersion> currentVersionSupplier;
    private static final int CONNECT_TIMEOUT_MS = 1000;
    private static final int REQUEST_TIMEOUT_MS = 8000;
    private static final String FLYWAY_URL = "https://repo1.maven.org/maven2/org/flywaydb/flyway-core/maven-metadata.xml";

    MavenVersionChecker() {
        this(FLYWAY_URL, MavenVersionChecker::getCurrentVersion);
    }

    String checkForVersionUpdates() {
        try {
            MavenMetadata metadata = this.getMavenMetadata();
            MigrationVersion current = this.currentVersionSupplier.get();
            MigrationVersion latest = MigrationVersion.fromVersion((String)metadata.getVersioning().getRelease());
            if (current.compareTo(latest) < 0) {
                return MavenVersionChecker.getMessage(latest);
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to check for updates: " + e.getMessage());
        }
        return null;
    }

    private MavenMetadata getMavenMetadata() throws URISyntaxException, ExecutionException, InterruptedException, JsonProcessingException {
        URI url = new URI(this.flywayUrl);
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(1000L)).build();
        HttpRequest request = HttpRequest.newBuilder(url).GET().header("User-Agent", "Flyway").timeout(Duration.ofMillis(8000L)).build();
        HttpResponse<String> response = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).orTimeout(8000L, TimeUnit.MILLISECONDS).get();
        ObjectMapper xmlMapper = new XmlMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (MavenMetadata)xmlMapper.readValue(response.body(), MavenMetadata.class);
    }

    private static MigrationVersion getCurrentVersion() {
        String currentVersion = VersionPrinter.getVersion();
        int idx = currentVersion.indexOf(45);
        currentVersion = idx >= 0 ? currentVersion.substring(0, idx) : currentVersion;
        return MigrationVersion.fromVersion((String)currentVersion);
    }

    private static String getMessage(MigrationVersion latest) {
        String message = "\nA more recent version of Flyway is available. Find out more about Flyway " + String.valueOf(latest) + " at https://rd.gt/3rXiSlV\n";
        String border = "-".repeat(message.trim().length());
        return "\n" + border + message + border;
    }

    @Generated
    MavenVersionChecker(String flywayUrl, Supplier<MigrationVersion> currentVersionSupplier) {
        this.flywayUrl = flywayUrl;
        this.currentVersionSupplier = currentVersionSupplier;
    }

    private static class MavenMetadata {
        private MavenVersioning versioning;

        @Generated
        public void setVersioning(MavenVersioning versioning) {
            this.versioning = versioning;
        }

        @Generated
        public MavenVersioning getVersioning() {
            return this.versioning;
        }

        @Generated
        public MavenMetadata() {
        }
    }

    private static class MavenVersioning {
        private String release;

        @Generated
        public void setRelease(String release) {
            this.release = release;
        }

        @Generated
        public String getRelease() {
            return this.release;
        }

        @Generated
        public MavenVersioning() {
        }
    }
}

