/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.flywaydb.commandline.JavaVersionPrinter;
import org.flywaydb.commandline.MavenVersionChecker;
import org.flywaydb.commandline.MigrationConfigPrinter;
import org.flywaydb.commandline.ThreadUtils;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.ConfigurationManagerImpl;
import org.flywaydb.commandline.logging.LoggingUtils;
import org.flywaydb.commandline.logging.console.ConsoleLog;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationFilter;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.ErrorOutput;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.InfoTelemetryModel;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.exception.FlywayMigrateException;
import org.flywaydb.core.internal.info.MigrationFilterImpl;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.flywaydb.core.internal.license.FlywayExpiredLicenseKeyException;
import org.flywaydb.core.internal.license.FlywayLicensingException;
import org.flywaydb.core.internal.logging.EvolvingLog;
import org.flywaydb.core.internal.logging.buffered.BufferedLog;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.publishing.OperationResultPublisher;
import org.flywaydb.core.internal.publishing.PublishingConfigurationExtension;
import org.flywaydb.core.internal.reports.ReportDetails;
import org.flywaydb.core.internal.reports.ReportGenerationOutput;
import org.flywaydb.core.internal.reports.ResultReportGenerator;
import org.flywaydb.core.internal.util.CommandExtensionUtils;
import org.flywaydb.core.internal.util.JsonUtils;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.TelemetryUtils;

public class Main {
    private static Log LOG;
    private static final PluginRegister PLUGIN_REGISTER;
    private static boolean hasPrintedLicense;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        long appStart = System.currentTimeMillis();
        long jvmStart = ManagementFactory.getRuntimeMXBean().getStartTime();
        int exitCode = 0;
        JavaVersionPrinter.printJavaVersion();
        EventTelemetryModel telemetryStartSpan = new EventTelemetryModel("telemetry-startup", null);
        FlywayTelemetryManager flywayTelemetryManager = (FlywayTelemetryManager)PLUGIN_REGISTER.getInstanceOf(FlywayTelemetryManager.class);
        AutoCloseable flywayTelemetryHandle = flywayTelemetryManager.start(telemetryStartSpan.getStartTime());
        flywayTelemetryManager.logEvent(telemetryStartSpan);
        try {
            CommandLineArguments commandLineArguments = new CommandLineArguments(PLUGIN_REGISTER, args);
            LOG = LoggingUtils.initLogging(Main.class, commandLineArguments);
            try {
                Configuration configuration;
                ReportGenerationOutput reportGenerationOutput = new ReportGenerationOutput();
                try (EventTelemetryModel ignored = new EventTelemetryModel("parse-args", flywayTelemetryManager);){
                    commandLineArguments.validate();
                    if (Main.printHelp(commandLineArguments)) {
                        ThreadUtils.terminate(0, flywayTelemetryHandle);
                        return;
                    }
                    LOG.debug("JVM startup time: " + (appStart - jvmStart) + "ms");
                    configuration = new ConfigurationManagerImpl().getConfiguration(commandLineArguments);
                    flywayTelemetryManager.notifyPermitChanged(LicenseGuard.getPermit((Configuration)configuration));
                    flywayTelemetryManager.notifyRootConfigChanged(configuration);
                }
                CompletableFuture<Object> updateCheckFuture = commandLineArguments.skipCheckForUpdate() || "json".equalsIgnoreCase(configuration.getModernConfig().getFlyway().getOutputType()) ? CompletableFuture.completedFuture(null) : CompletableFuture.supplyAsync(() -> {
                    try (EventTelemetryModel ignored = new EventTelemetryModel("check-for-update", flywayTelemetryManager);){
                        String string = new MavenVersionChecker().checkForVersionUpdates();
                        return string;
                    }
                });
                LocalDateTime executionTime = LocalDateTime.now();
                OperationResult result = Main.executeFlyway(flywayTelemetryManager, commandLineArguments, configuration);
                List reportGenerators = PLUGIN_REGISTER.getInstancesOf(ResultReportGenerator.class);
                for (ResultReportGenerator resultReportGenerator : reportGenerators) {
                    reportGenerationOutput = resultReportGenerator.generateReport(result, configuration, executionTime);
                }
                if (((PublishingConfigurationExtension)configuration.getPluginRegister().getExact(PublishingConfigurationExtension.class)).isPublishResult()) {
                    Main.publishOperationResult(configuration, result);
                    Main.publishReport(configuration, reportGenerationOutput.reportDetails);
                }
                if (reportGenerationOutput.aggregateException != null) {
                    throw reportGenerationOutput.aggregateException;
                }
                if (commandLineArguments.shouldOutputJson()) {
                    Main.printJson(commandLineArguments, result, reportGenerationOutput.reportDetails);
                }
                Main.printUpdateMessage(updateCheckFuture);
            }
            catch (FlywayLicensingException e) {
                OperationResult errorOutput = ErrorOutput.toOperationResult((Exception)((Object)e));
                Main.printError(commandLineArguments, (Exception)((Object)e), errorOutput);
                exitCode = 35;
            }
            catch (Exception e) {
                OperationResult errorOutput = ErrorOutput.toOperationResult((Exception)e);
                Main.printError(commandLineArguments, e, errorOutput);
                exitCode = 1;
            }
            finally {
                Main.flushLog(commandLineArguments);
            }
        }
        finally {
            ThreadUtils.terminate(exitCode, flywayTelemetryHandle);
        }
    }

    private static void printLicenseInfo(Configuration configuration, String operation) {
        if (!hasPrintedLicense && !"auth".equals(operation)) {
            try {
                LicenseGuard.getPermit((Configuration)configuration).print();
                LOG.info("See release notes here: https://rd.gt/416ObMi");
            }
            catch (FlywayExpiredLicenseKeyException e) {
                LOG.error(e.getMessage());
            }
            hasPrintedLicense = true;
        }
    }

    private static void printUpdateMessage(CompletableFuture<String> updateCheckFuture) throws ExecutionException, InterruptedException {
        String updateMessage;
        if (updateCheckFuture.isDone() && !updateCheckFuture.isCompletedExceptionally() && !updateCheckFuture.isCancelled() && (updateMessage = updateCheckFuture.get()) != null) {
            LOG.info(updateMessage);
        }
    }

    private static OperationResult executeFlyway(FlywayTelemetryManager flywayTelemetryManager, CommandLineArguments commandLineArguments, Configuration configuration) {
        CompositeResult result;
        Flyway flyway = Flyway.configure((ClassLoader)configuration.getClassLoader()).configuration(configuration).load();
        Configuration executionConfiguration = flyway.getConfiguration();
        if (commandLineArguments.getOperations().size() == 1) {
            String operation = commandLineArguments.getOperations().get(0);
            Main.printLicenseInfo(configuration, operation);
            result = Main.executeOperation(flyway, operation, commandLineArguments, flywayTelemetryManager, executionConfiguration);
        } else {
            CompositeResult compositeResult = new CompositeResult();
            for (String operation : commandLineArguments.getOperations()) {
                Main.printLicenseInfo(configuration, operation);
                OperationResult operationResult = Main.executeOperation(flyway, operation, commandLineArguments, flywayTelemetryManager, executionConfiguration);
                compositeResult.individualResults.add(operationResult);
                if (!(operationResult instanceof HtmlResult) || !(((HtmlResult)operationResult).exceptionObject instanceof FlywayMigrateException)) continue;
                break;
            }
            result = compositeResult;
        }
        if (configuration instanceof ClassicConfiguration) {
            ClassicConfiguration classicConfiguration = (ClassicConfiguration)configuration;
            classicConfiguration.configure(executionConfiguration);
        }
        if (configuration instanceof FluentConfiguration) {
            FluentConfiguration fluentConfiguration = (FluentConfiguration)configuration;
            fluentConfiguration.configuration(executionConfiguration);
        }
        return result;
    }

    private static void printError(CommandLineArguments commandLineArguments, Exception e, OperationResult errorResult) throws JsonProcessingException {
        if (commandLineArguments.shouldOutputJson()) {
            Main.printJson(commandLineArguments, errorResult, null);
        } else if (commandLineArguments.getLogLevel() == ConsoleLog.Level.DEBUG) {
            LOG.error("Unexpected error", e);
        } else {
            LOG.error(Main.getMessagesFromException(e));
        }
        Main.flushLog(commandLineArguments);
    }

    private static void flushLog(CommandLineArguments commandLineArguments) {
        Log currentLog = ((EvolvingLog)LOG).getLog();
        if (currentLog instanceof BufferedLog) {
            ((BufferedLog)currentLog).flush(LoggingUtils.getLogCreator(commandLineArguments).createLogger(Main.class));
        }
    }

    private static String getMessagesFromException(Throwable e) {
        StringBuilder condensedMessages = new StringBuilder();
        String preamble = "";
        while (e != null) {
            if (e instanceof FlywayException) {
                condensedMessages.append(preamble).append(e.getMessage());
            } else {
                condensedMessages.append(preamble).append(e);
            }
            preamble = "\r\nCaused by: ";
            e = e.getCause();
        }
        return condensedMessages.toString();
    }

    private static OperationResult executeOperation(Flyway flyway, String operation, CommandLineArguments commandLineArguments, FlywayTelemetryManager telemetryManager, Configuration configuration) {
        Object result;
        block31: {
            result = null;
            flyway.setFlywayTelemetryManager(telemetryManager);
            if ("clean".equals(operation)) {
                result = flyway.clean();
            } else if ("baseline".equals(operation)) {
                result = flyway.baseline();
            } else if ("migrate".equals(operation)) {
                try {
                    result = flyway.migrate();
                }
                catch (FlywayMigrateException e) {
                    result = ErrorOutput.fromMigrateException((FlywayMigrateException)e);
                    HtmlResult hr = (HtmlResult)result;
                    hr.setException((Exception)((Object)e));
                }
            } else if ("validate".equals(operation)) {
                try (EventTelemetryModel telemetryModel = new EventTelemetryModel("validate", telemetryManager);){
                    try {
                        if (commandLineArguments.shouldOutputJson()) {
                            result = flyway.validateWithResult();
                        }
                        flyway.validate();
                    }
                    catch (Exception e) {
                        telemetryModel.setException(e);
                        throw e;
                    }
                }
            } else {
                if ("info".equals(operation)) {
                    try (InfoTelemetryModel infoTelemetryModel = new InfoTelemetryModel(telemetryManager);){
                        try {
                            MigrationInfoService info = flyway.info();
                            MigrationInfo current = info.current();
                            MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
                            MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
                            LOG.info("Schema version: " + String.valueOf(schemaVersionToOutput));
                            LOG.info("");
                            MigrationFilterImpl filter = Main.getInfoFilter(commandLineArguments);
                            result = info.getInfoResult((MigrationFilter)filter);
                            MigrationInfo[] infos = info.all((MigrationFilter)filter);
                            boolean hasOnDiskMigrations = Arrays.stream(infos).map(MigrationInfo::getPhysicalLocation).anyMatch(StringUtils::hasLength);
                            if (!hasOnDiskMigrations) {
                                LOG.info("No migrations found on disk.\nHere are some relevant configuration settings.");
                                MigrationConfigPrinter.print(LOG, configuration);
                            }
                            if (commandLineArguments.isFilterOnMigrationIds()) {
                                System.out.print(MigrationInfoDumper.dumpToMigrationIds((MigrationInfo[])infos));
                            } else {
                                LOG.info(MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])infos));
                            }
                            infoTelemetryModel.setNumberOfMigrations(((InfoResult)result).migrations.size());
                            infoTelemetryModel.setNumberOfPendingMigrations((int)((InfoResult)result).migrations.stream().filter(m -> "Pending".equals(m.state)).count());
                            infoTelemetryModel.setOldestMigrationInstalledOnUTC(TelemetryUtils.getOldestMigration((List)((InfoResult)result).migrations));
                            break block31;
                        }
                        catch (Exception e) {
                            infoTelemetryModel.setException(e);
                            throw e;
                        }
                    }
                }
                result = "repair".equals(operation) ? flyway.repair() : ("undo".equals(operation) ? flyway.undo() : CommandExtensionUtils.runCommandExtension((Configuration)configuration, (String)operation, commandLineArguments.getFlags()));
            }
        }
        return result;
    }

    private static void publishOperationResult(Configuration configuration, OperationResult result) {
        if (result == null) {
            LOG.debug("Unable to publish null operation result");
            return;
        }
        List publishers = configuration.getPluginRegister().getInstancesOf(OperationResultPublisher.class);
        for (OperationResultPublisher publisher : publishers) {
            publisher.publish(configuration, result);
        }
    }

    private static void publishReport(Configuration configuration, ReportDetails reportDetails) {
        List publishers = configuration.getPluginRegister().getInstancesOf(OperationResultPublisher.class);
        for (OperationResultPublisher publisher : publishers) {
            publisher.publishReport(configuration, reportDetails);
        }
    }

    private static MigrationFilterImpl getInfoFilter(CommandLineArguments commandLineArguments) {
        return new MigrationFilterImpl(commandLineArguments.getInfoSinceDate(), commandLineArguments.getInfoUntilDate(), commandLineArguments.getInfoSinceVersion(), commandLineArguments.getInfoUntilVersion(), commandLineArguments.getInfoOfState());
    }

    private static void printJson(CommandLineArguments commandLineArguments, OperationResult object, ReportDetails reportDetails) throws JsonProcessingException {
        String json = Main.convertObjectToJsonString(object, reportDetails);
        if (commandLineArguments.isOutputFileSet()) {
            Path path = Paths.get(commandLineArguments.getOutputFile(), new String[0]);
            byte[] bytes = json.getBytes();
            try {
                Files.write(path, bytes, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new FlywayException("Could not write to output file " + commandLineArguments.getOutputFile(), (Throwable)e);
            }
        }
        System.out.println(json);
    }

    private static String convertObjectToJsonString(Object object, ReportDetails reportDetails) throws JsonProcessingException {
        JsonMapper mapper = JsonUtils.getJsonMapper();
        ObjectNode objectNode = (ObjectNode)mapper.valueToTree(object);
        if (reportDetails != null) {
            if (reportDetails.getJsonReportFilename() != null) {
                objectNode.put("jsonReport", reportDetails.getJsonReportFilename());
            }
            if (reportDetails.getHtmlReportFilename() != null) {
                objectNode.put("htmlReport", reportDetails.getHtmlReportFilename());
            }
        }
        return mapper.writeValueAsString((Object)objectNode);
    }

    private static void printUsage(Boolean fullVersion) {
        String indent = "    ";
        LOG.info("Usage");
        LOG.info("    flyway [options] [command]");
        LOG.info("    flyway help [command]");
        LOG.info("");
        if (fullVersion.booleanValue()) {
            LOG.info("By default, the configuration will be read from conf/flyway.toml file.");
            LOG.info("Options passed from the command-line override the configuration.");
            LOG.info("");
        }
        LOG.info("Commands");
        List usages = PLUGIN_REGISTER.getInstancesOf(CommandExtension.class).stream().flatMap(e -> e.getUsage().stream().map(p -> e.inPreview() ? Pair.of((Object)((String)p.getLeft() + " (preview)"), (Object)((String)p.getRight())) : p)).toList();
        int padSize = usages.stream().max(Comparator.comparingInt(u -> ((String)u.getLeft()).length())).map(u -> ((String)u.getLeft()).length() + 3).orElse(11);
        LOG.info("    " + StringUtils.rightPad((String)"help", (int)padSize, (char)' ') + "Print this usage info and exit");
        LOG.info("    " + StringUtils.rightPad((String)"migrate", (int)padSize, (char)' ') + "Migrates the database");
        LOG.info("    " + StringUtils.rightPad((String)"clean", (int)padSize, (char)' ') + "Drops all objects in the configured schemas");
        LOG.info("    " + StringUtils.rightPad((String)"info", (int)padSize, (char)' ') + "Prints the information about applied, current and pending migrations");
        LOG.info("    " + StringUtils.rightPad((String)"validate", (int)padSize, (char)' ') + "Validates the applied migrations against the ones on the classpath");
        LOG.info("    " + StringUtils.rightPad((String)"baseline", (int)padSize, (char)' ') + "Baselines an existing database at the baselineVersion");
        LOG.info("    " + StringUtils.rightPad((String)"repair", (int)padSize, (char)' ') + "Repairs the schema history table");
        for (Pair usage : usages) {
            List<String> lines = Arrays.stream(((String)usage.getRight()).split("\n")).map(String::trim).toList();
            LOG.info("    " + StringUtils.rightPad((String)((String)usage.getLeft()), (int)padSize, (char)' ') + lines.get(0));
            for (int i = 1; i < lines.size(); ++i) {
                LOG.info("    " + " ".repeat(padSize) + lines.get(i));
            }
        }
        LOG.info("");
        LOG.info("Configuration parameters (Format: -key=value)");
        LOG.info("    driver                         Fully qualified classname of the JDBC driver");
        LOG.info("    url                            Jdbc url to use to connect to the database");
        LOG.info("    user                           User to use to connect to the database");
        LOG.info("    password                       Password to use to connect to the database");
        if (fullVersion.booleanValue()) {
            LOG.info("    connectRetries                 Maximum number of retries when attempting to connect to the database");
            LOG.info("    initSql                        SQL statements to run to initialize a new database connection");
            LOG.info("    schemas                        Comma-separated list of the schemas managed by Flyway");
            LOG.info("    table                          Name of Flyway's schema history table");
            LOG.info("    locations                      Classpath locations to scan recursively for migrations");
            LOG.info("    failOnMissingLocations         Whether to fail if a location specified in the flyway.locations option doesn't exist");
            LOG.info("    resolvers                      Comma-separated list of custom MigrationResolvers");
            LOG.info("    skipDefaultResolvers           Skips default resolvers (jdbc, sql and Spring-jdbc)");
            LOG.info("    sqlMigrationPrefix             File name prefix for versioned SQL migrations");
            LOG.info("    undoSqlMigrationPrefix         [teams] File name prefix for undo SQL migrations");
            LOG.info("    repeatableSqlMigrationPrefix   File name prefix for repeatable SQL migrations");
            LOG.info("    sqlMigrationSeparator          File name separator for SQL migrations");
            LOG.info("    sqlMigrationSuffixes           Comma-separated list of file name suffixes for SQL migrations");
            LOG.info("    stream                         [teams] Stream SQL migrations when executing them");
            LOG.info("    batch                          [teams] Batch SQL statements when executing them");
            LOG.info("    mixed                          Allow mixing transactional and non-transactional statements");
            LOG.info("    encoding                       Encoding of SQL migrations");
            LOG.info("    detectEncoding                 [teams] Whether Flyway should try to automatically detect SQL migration file encoding");
            LOG.info("    executeInTransaction           Whether SQL should execute within a transaction");
            LOG.info("    placeholderReplacement         Whether placeholders should be replaced");
            LOG.info("    placeholders                   Placeholders to replace in sql migrations");
            LOG.info("    placeholderPrefix              Prefix of every placeholder");
            LOG.info("    placeholderSuffix              Suffix of every placeholder");
            LOG.info("    scriptPlaceholderPrefix        Prefix of every script placeholder");
            LOG.info("    scriptPlaceholderSuffix        Suffix of every script placeholder");
            LOG.info("    lockRetryCount                 The maximum number of retries when trying to obtain a lock");
            LOG.info("    jdbcProperties                 Properties to pass to the JDBC driver object");
            LOG.info("    installedBy                    Username that will be recorded in the schema history table");
            LOG.info("    target                         Target version up to which Flyway should use migrations");
            LOG.info("    cherryPick                     [teams] Comma separated list of migrations that Flyway should consider when migrating");
            LOG.info("    skipExecutingMigrations        Whether Flyway should skip actually executing the contents of the migrations");
            LOG.info("    outOfOrder                     Allows migrations to be run \"out of order\"");
            LOG.info("    callbacks                      Comma-separated list of FlywayCallback classes, or locations to scan for FlywayCallback classes");
            LOG.info("    skipDefaultCallbacks           Skips default callbacks (sql)");
            LOG.info("    validateOnMigrate              Validate when running migrate");
            LOG.info("    validateMigrationNaming        Validate file names of SQL migrations (including callbacks)");
            LOG.info("    ignoreMigrationPatterns        Patterns of migrations and states to ignore during validate");
            LOG.info("    cleanDisabled                  Whether to disable clean");
            LOG.info("    baselineVersion                Version to tag schema with when executing baseline");
            LOG.info("    baselineDescription            Description to tag schema with when executing baseline");
            LOG.info("    baselineOnMigrate              Baseline on migrate against uninitialized non-empty schema");
            LOG.info("    configFiles                    Comma-separated list of config files to use");
            LOG.info("    configFileEncoding             Encoding to use when loading the config files");
            LOG.info("    jarDirs                        Comma-separated list of dirs for Jdbc drivers & Java migrations");
            LOG.info("    createSchemas                  Whether Flyway should attempt to create the schemas specified in the schemas property");
            LOG.info("    dryRunOutput                   [teams] File where to output the SQL statements of a migration dry run");
            LOG.info("    errorOverrides                 [teams] Rules to override specific SQL states and errors codes");
            LOG.info("    color                          Whether to colorize output. Values: always, never, or auto (default)");
            LOG.info("    outputFile                     Send output to the specified file alongside the console");
            LOG.info("    outputType                     Serialise the output in the given format, Values: json");
        } else {
            LOG.info("    (To see all configuration options please run flyway --help)");
        }
        LOG.info("");
        LOG.info("Flags");
        LOG.info("    -X                Print debug output");
        LOG.info("    -q                Suppress all output, except for errors and warnings");
        LOG.info("    --help, -h, -?    Print this usage info and exit");
        LOG.info("");
        LOG.info("Flyway Usage Example");
        LOG.info("    flyway -user=myuser -password=s3cr3t -url=jdbc:h2:mem -placeholders.abc=def migrate");
        LOG.info("    flyway help check");
        LOG.info("");
        LOG.info("More info at https://rd.gt/3Cc1xKC");
    }

    private static boolean printHelp(CommandLineArguments commandLineArguments) {
        StringBuilder helpText = new StringBuilder();
        CommandLineArguments.PrintUsage result = commandLineArguments.shouldPrintUsage(helpText);
        if (result == CommandLineArguments.PrintUsage.PRINT_NONE) {
            return false;
        }
        if (StringUtils.hasText((String)helpText.toString())) {
            LOG.info(helpText.toString());
        } else {
            Main.printUsage(result == CommandLineArguments.PrintUsage.PRINT_ORIGINAL);
        }
        return true;
    }

    static {
        PLUGIN_REGISTER = new PluginRegister();
    }
}

