/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.command.dbsupport;

import java.util.List;
import lombok.Generated;
import org.flywaydb.commandline.command.dbsupport.DbInfoResult;
import org.flywaydb.commandline.command.dbsupport.DbSupportResult;
import org.flywaydb.core.TelemetrySpan;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.TelemetryUtils;

public class ListEnginesCommandExtension
implements CommandExtension {
    @Generated
    private static final Log LOG = LogFactory.getLog(ListEnginesCommandExtension.class);
    private static final String DB_SUPPORT = "list-engines";
    private static final String HEADERS_DATABASE_NAME = "Database Name";

    public boolean handlesCommand(String command) {
        return command.equals(DB_SUPPORT);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    public OperationResult handle(String command, Configuration config, List<String> flags) throws FlywayException {
        return (OperationResult)TelemetrySpan.trackSpan((EventTelemetryModel)new EventTelemetryModel(DB_SUPPORT, TelemetryUtils.getTelemetryManager((Configuration)config)), telemetryModel -> this.listEngines(config));
    }

    private DbSupportResult listEngines(Configuration config) {
        List<DbInfoResult> databaseInfos = this.getEngines(config);
        if (!databaseInfos.isEmpty()) {
            int nameLength = databaseInfos.stream().map(p -> p.name().length()).max(Integer::compare).get() + 2;
            if (nameLength < HEADERS_DATABASE_NAME.length() + 2) {
                nameLength = HEADERS_DATABASE_NAME.length() + 2;
            }
            LOG.info(StringUtils.rightPad((String)HEADERS_DATABASE_NAME, (int)nameLength, (char)' '));
            LOG.info(StringUtils.rightPad((String)StringUtils.leftPad((String)"", (int)nameLength, (char)'-'), (int)nameLength, (char)' '));
            for (DbInfoResult p2 : databaseInfos) {
                LOG.info(StringUtils.rightPad((String)p2.name(), (int)nameLength, (char)' '));
            }
        }
        return new DbSupportResult(VersionPrinter.getVersion(), DB_SUPPORT, LicenseGuard.getTier((Configuration)config), databaseInfos);
    }

    public List<Pair<String, String>> getUsage() {
        return List.of(Pair.of((Object)DB_SUPPORT, (Object)"Lists the database engines that Flyway has loaded support for."));
    }

    public List<DbInfoResult> getEngines(Configuration config) {
        return config.getPluginRegister().getPlugins(DatabaseType.class).stream().map(p -> new DbInfoResult(p.getName())).toList();
    }
}

