/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.CommandLineConfigurationUtils;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.commandline.configuration.LegacyConfigurationManager;
import org.flywaydb.commandline.configuration.ModernConfigurationManager;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.util.ClassUtils;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    private static final Log LOG = LogFactory.getLog(ConfigurationManagerImpl.class);

    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        ConfigurationManager configurationManager = this.useModernConfig(commandLineArguments) ? new ModernConfigurationManager() : new LegacyConfigurationManager();
        return configurationManager.getConfiguration(commandLineArguments);
    }

    private boolean useModernConfig(CommandLineArguments commandLineArguments) {
        ArrayList<File> tomlFiles = new ArrayList<File>();
        tomlFiles.addAll(ConfigUtils.getDefaultTomlConfigFileLocations((File)new File(ClassUtils.getInstallDir(Main.class))));
        tomlFiles.addAll(CommandLineConfigurationUtils.getTomlConfigFilePaths());
        tomlFiles.addAll(commandLineArguments.getConfigFiles().stream().filter(f -> f.endsWith(".toml")).map(File::new).collect(Collectors.toList()));
        return tomlFiles.stream().anyMatch(File::exists);
    }
}

