/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.testconnection;

import java.util.Optional;
import lombok.Generated;
import org.flywaydb.core.FlywayExecutor;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.TestConnectionRunner;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.nc.NativeConnectorsModeUtils;

public class FlywayTestConnectionRunner
implements TestConnectionRunner {
    @Generated
    private static final Log LOG = LogFactory.getLog(FlywayTestConnectionRunner.class);
    private static final String CONNECTION_SUCCESSFUL = "Flyway engine connection successful";

    public String testConnection(Configuration configuration) {
        if (NativeConnectorsModeUtils.canUseNativeConnectors((Configuration)configuration, (String)"testConnection")) {
            Optional<VerbExtension> verb = configuration.getPluginRegister().getInstancesOf(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("testConnection")).findFirst();
            if (verb.isPresent()) {
                LOG.debug("Native Connectors for testConnection is set and a verb is present");
                verb.get().executeVerb(configuration);
                LOG.info(CONNECTION_SUCCESSFUL);
                return "Flyway";
            }
            LOG.warn("Native Connectors for testConnection is set but no verb is present");
        }
        try (JdbcConnectionFactory ignored = new FlywayExecutor(configuration).init();){
            LOG.info(CONNECTION_SUCCESSFUL);
            String string = "Flyway";
            return string;
        }
    }
}

