/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.testconnection;

import java.util.List;
import lombok.Generated;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.TelemetrySpan;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.TestConnectionRunner;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.TelemetryUtils;
import org.flywaydb.testconnection.TestConnectionResult;

public class TestConnectionCommandExtension
implements CommandExtension {
    @Generated
    private static final Log LOG = LogFactory.getLog(TestConnectionCommandExtension.class);
    public static final String VERB = "testConnection";

    public boolean handlesCommand(String command) {
        return VERB.equals(command);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    public List<Pair<String, String>> getUsage() {
        return List.of(Pair.of((Object)VERB, (Object)"Attempts to establish a connection to the database using the configured connection settings"));
    }

    public String getDescription() {
        return "Attempts to establish a connection to the database using the configured connection settings.\nIf successful, Flyway exits with a zero status code.\nIf unsuccessful, Flyway exits with a non-zero status code and an error message is displayed.\n";
    }

    public String getExample() {
        return "flyway testConnection -environment=development";
    }

    public OperationResult handle(String command, Configuration config, List<String> flags) throws FlywayException {
        FlywayTelemetryManager flywayTelemetryManager = TelemetryUtils.getTelemetryManager((Configuration)config);
        return (OperationResult)TelemetrySpan.trackSpan((EventTelemetryModel)new EventTelemetryModel(VERB, flywayTelemetryManager), telemetryModel -> {
            List testConnectionRunners = config.getPluginRegister().getLicensedInstancesOf(TestConnectionRunner.class, config);
            List<String> results = testConnectionRunners.stream().map(testConnectionRunner -> testConnectionRunner.testConnection(config)).filter(x -> !x.isEmpty()).toList();
            return new TestConnectionResult(results);
        });
    }
}

